/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jasic;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Jasic {
    private final Map<String, Value> variables = new HashMap<String, Value>();
    private final Map<String, Integer> labels = new HashMap<String, Integer>();
    private final BufferedReader lineIn;
    private int currentStatement;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: jasic <script>");
            System.out.println("Where <script> is a relative path to a .jas script to run.");
            return;
        }
        String string = Jasic.readFile(stringArray[0]);
        Jasic jasic = new Jasic();
        jasic.interpret(string);
    }

    private static List<Token> tokenize(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        String string2 = "";
        TokenizeState tokenizeState = TokenizeState.DEFAULT;
        String string3 = "\n=+-*/<>()";
        TokenType[] tokenTypeArray = new TokenType[]{TokenType.LINE, TokenType.EQUALS, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.OPERATOR, TokenType.LEFT_PAREN, TokenType.RIGHT_PAREN};
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (tokenizeState) {
                case DEFAULT: {
                    if (string3.indexOf(c) != -1) {
                        arrayList.add(new Token(Character.toString(c), tokenTypeArray[string3.indexOf(c)]));
                        continue block7;
                    }
                    if (Character.isLetter(c)) {
                        string2 = string2 + c;
                        tokenizeState = TokenizeState.WORD;
                        continue block7;
                    }
                    if (Character.isDigit(c)) {
                        string2 = string2 + c;
                        tokenizeState = TokenizeState.NUMBER;
                        continue block7;
                    }
                    if (c == '\"') {
                        tokenizeState = TokenizeState.STRING;
                        continue block7;
                    }
                    if (c != '\'') continue block7;
                    tokenizeState = TokenizeState.COMMENT;
                    continue block7;
                }
                case WORD: {
                    if (Character.isLetterOrDigit(c)) {
                        string2 = string2 + c;
                        continue block7;
                    }
                    if (c == ':') {
                        arrayList.add(new Token(string2, TokenType.LABEL));
                        string2 = "";
                        tokenizeState = TokenizeState.DEFAULT;
                        continue block7;
                    }
                    arrayList.add(new Token(string2, TokenType.WORD));
                    string2 = "";
                    tokenizeState = TokenizeState.DEFAULT;
                    --i;
                    continue block7;
                }
                case NUMBER: {
                    if (Character.isDigit(c)) {
                        string2 = string2 + c;
                        continue block7;
                    }
                    arrayList.add(new Token(string2, TokenType.NUMBER));
                    string2 = "";
                    tokenizeState = TokenizeState.DEFAULT;
                    --i;
                    continue block7;
                }
                case STRING: {
                    if (c == '\"') {
                        arrayList.add(new Token(string2, TokenType.STRING));
                        string2 = "";
                        tokenizeState = TokenizeState.DEFAULT;
                        continue block7;
                    }
                    string2 = string2 + c;
                    continue block7;
                }
                case COMMENT: {
                    if (c != '\n') continue block7;
                    tokenizeState = TokenizeState.DEFAULT;
                }
            }
        }
        return arrayList;
    }

    public Jasic() {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        this.lineIn = new BufferedReader(inputStreamReader);
    }

    public void interpret(String string) {
        List<Token> list = Jasic.tokenize(string);
        Parser parser = new Parser(list);
        List<Statement> list2 = parser.parse(this.labels);
        this.currentStatement = 0;
        while (this.currentStatement < list2.size()) {
            int n = this.currentStatement++;
            list2.get(n).execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String string) {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[8192];
            while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
            stringBuilder.append("\n");
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        fileInputStream.close();
        return string2;
    }

    public class StringValue
    implements Value {
        private final String value;

        public StringValue(String string) {
            this.value = string;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @Override
        public double toNumber() {
            return Double.parseDouble(this.value);
        }

        @Override
        public Value evaluate() {
            return this;
        }
    }

    public class NumberValue
    implements Value {
        private final double value;

        public NumberValue(double d) {
            this.value = d;
        }

        @Override
        public String toString() {
            return Double.toString(this.value);
        }

        @Override
        public double toNumber() {
            return this.value;
        }

        @Override
        public Value evaluate() {
            return this;
        }
    }

    public static interface Value
    extends Expression {
        public String toString();

        public double toNumber();
    }

    public class OperatorExpression
    implements Expression {
        private final Expression left;
        private final char operator;
        private final Expression right;

        public OperatorExpression(Expression expression, char c, Expression expression2) {
            this.left = expression;
            this.operator = c;
            this.right = expression2;
        }

        @Override
        public Value evaluate() {
            Value value = this.left.evaluate();
            Value value2 = this.right.evaluate();
            switch (this.operator) {
                case '=': {
                    if (value instanceof NumberValue) {
                        return new NumberValue(value.toNumber() == value2.toNumber() ? 1.0 : 0.0);
                    }
                    return new NumberValue(value.toString().equals(value2.toString()) ? 1.0 : 0.0);
                }
                case '+': {
                    if (value instanceof NumberValue) {
                        return new NumberValue(value.toNumber() + value2.toNumber());
                    }
                    return new StringValue(value.toString() + value2.toString());
                }
                case '-': {
                    return new NumberValue(value.toNumber() - value2.toNumber());
                }
                case '*': {
                    return new NumberValue(value.toNumber() * value2.toNumber());
                }
                case '/': {
                    return new NumberValue(value.toNumber() / value2.toNumber());
                }
                case '<': {
                    if (value instanceof NumberValue) {
                        return new NumberValue(value.toNumber() < value2.toNumber() ? 1.0 : 0.0);
                    }
                    return new NumberValue(value.toString().compareTo(value2.toString()) < 0 ? 1.0 : 0.0);
                }
                case '>': {
                    if (value instanceof NumberValue) {
                        return new NumberValue(value.toNumber() > value2.toNumber() ? 1.0 : 0.0);
                    }
                    return new NumberValue(value.toString().compareTo(value2.toString()) > 0 ? 1.0 : 0.0);
                }
            }
            throw new Error("Unknown operator.");
        }
    }

    public class VariableExpression
    implements Expression {
        private final String name;

        public VariableExpression(String string) {
            this.name = string;
        }

        @Override
        public Value evaluate() {
            if (Jasic.this.variables.containsKey(this.name)) {
                return (Value)Jasic.this.variables.get(this.name);
            }
            return new NumberValue(0.0);
        }
    }

    public class IfThenStatement
    implements Statement {
        private final Expression condition;
        private final String label;

        public IfThenStatement(Expression expression, String string) {
            this.condition = expression;
            this.label = string;
        }

        @Override
        public void execute() {
            double d;
            if (Jasic.this.labels.containsKey(this.label) && (d = this.condition.evaluate().toNumber()) != 0.0) {
                Jasic.this.currentStatement = (Integer)Jasic.this.labels.get(this.label);
            }
        }
    }

    public class GotoStatement
    implements Statement {
        private final String label;

        public GotoStatement(String string) {
            this.label = string;
        }

        @Override
        public void execute() {
            if (Jasic.this.labels.containsKey(this.label)) {
                Jasic.this.currentStatement = (Integer)Jasic.this.labels.get(this.label);
            }
        }
    }

    public class AssignStatement
    implements Statement {
        private final String name;
        private final Expression value;

        public AssignStatement(String string, Expression expression) {
            this.name = string;
            this.value = expression;
        }

        @Override
        public void execute() {
            Jasic.this.variables.put(this.name, this.value.evaluate());
        }
    }

    public class InputStatement
    implements Statement {
        private final String name;

        public InputStatement(String string) {
            this.name = string;
        }

        @Override
        public void execute() {
            try {
                String string = Jasic.this.lineIn.readLine();
                try {
                    double d = Double.parseDouble(string);
                    Jasic.this.variables.put(this.name, new NumberValue(d));
                }
                catch (NumberFormatException numberFormatException) {
                    Jasic.this.variables.put(this.name, new StringValue(string));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class PrintStatement
    implements Statement {
        private final Expression expression;

        public PrintStatement(Expression expression) {
            this.expression = expression;
        }

        @Override
        public void execute() {
            System.out.println(this.expression.evaluate().toString());
        }
    }

    public static interface Expression {
        public Value evaluate();
    }

    public static interface Statement {
        public void execute();
    }

    private class Parser {
        private final List<Token> tokens;
        private int position;

        public Parser(List<Token> list) {
            this.tokens = list;
            this.position = 0;
        }

        public List<Statement> parse(Map<String, Integer> map) {
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            while (true) {
                Object object;
                Object object2;
                if (this.match(TokenType.LINE)) {
                    continue;
                }
                if (this.match(TokenType.LABEL)) {
                    map.put(this.last((int)1).text, arrayList.size());
                    continue;
                }
                if (this.match(TokenType.WORD, TokenType.EQUALS)) {
                    object2 = this.last((int)2).text;
                    object = this.expression();
                    arrayList.add(new AssignStatement((String)object2, (Expression)object));
                    continue;
                }
                if (this.match("print")) {
                    arrayList.add(new PrintStatement(this.expression()));
                    continue;
                }
                if (this.match("input")) {
                    arrayList.add(new InputStatement(this.consume((TokenType)TokenType.WORD).text));
                    continue;
                }
                if (this.match("goto")) {
                    arrayList.add(new GotoStatement(this.consume((TokenType)TokenType.WORD).text));
                    continue;
                }
                if (!this.match("if")) break;
                object2 = this.expression();
                this.consume("then");
                object = this.consume((TokenType)TokenType.WORD).text;
                arrayList.add(new IfThenStatement((Expression)object2, (String)object));
            }
            return arrayList;
        }

        private Expression expression() {
            return this.operator();
        }

        private Expression operator() {
            Expression expression = this.atomic();
            while (this.match(TokenType.OPERATOR) || this.match(TokenType.EQUALS)) {
                char c = this.last((int)1).text.charAt(0);
                Expression expression2 = this.atomic();
                expression = new OperatorExpression(expression, c, expression2);
            }
            return expression;
        }

        private Expression atomic() {
            if (this.match(TokenType.WORD)) {
                return new VariableExpression(this.last((int)1).text);
            }
            if (this.match(TokenType.NUMBER)) {
                return new NumberValue(Double.parseDouble(this.last((int)1).text));
            }
            if (this.match(TokenType.STRING)) {
                return new StringValue(this.last((int)1).text);
            }
            if (this.match(TokenType.LEFT_PAREN)) {
                Expression expression = this.expression();
                this.consume(TokenType.RIGHT_PAREN);
                return expression;
            }
            throw new Error("Couldn't parse :(");
        }

        private boolean match(TokenType tokenType, TokenType tokenType2) {
            if (this.get((int)0).type != tokenType) {
                return false;
            }
            if (this.get((int)1).type != tokenType2) {
                return false;
            }
            this.position += 2;
            return true;
        }

        private boolean match(TokenType tokenType) {
            if (this.get((int)0).type != tokenType) {
                return false;
            }
            ++this.position;
            return true;
        }

        private boolean match(String string) {
            if (this.get((int)0).type != TokenType.WORD) {
                return false;
            }
            if (!this.get((int)0).text.equals(string)) {
                return false;
            }
            ++this.position;
            return true;
        }

        private Token consume(TokenType tokenType) {
            if (this.get((int)0).type != tokenType) {
                throw new Error("Expected " + (Object)((Object)tokenType) + ".");
            }
            return this.tokens.get(this.position++);
        }

        private Token consume(String string) {
            if (!this.match(string)) {
                throw new Error("Expected " + string + ".");
            }
            return this.last(1);
        }

        private Token last(int n) {
            return this.tokens.get(this.position - n);
        }

        private Token get(int n) {
            if (this.position + n >= this.tokens.size()) {
                return new Token("", TokenType.EOF);
            }
            return this.tokens.get(this.position + n);
        }
    }

    private static enum TokenizeState {
        DEFAULT,
        WORD,
        NUMBER,
        STRING,
        COMMENT;

    }

    private static class Token {
        public final String text;
        public final TokenType type;

        public Token(String string, TokenType tokenType) {
            this.text = string;
            this.type = tokenType;
        }
    }

    private static enum TokenType {
        WORD,
        NUMBER,
        STRING,
        LABEL,
        LINE,
        EQUALS,
        OPERATOR,
        LEFT_PAREN,
        RIGHT_PAREN,
        EOF;

    }
}

