/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.openiconic.SvgCommand;
import net.sourceforge.plantuml.openiconic.SvgCommandLetter;
import net.sourceforge.plantuml.openiconic.SvgCommandNumber;
import net.sourceforge.plantuml.openiconic.SvgPosition;

public class Movement {
    private final SvgCommandLetter letter;
    private final List<SvgCommandNumber> arguments;

    public Movement(Iterator<SvgCommand> iterator) {
        this.letter = (SvgCommandLetter)iterator.next();
        int n = this.letter.argumentNumber();
        SvgCommandNumber[] svgCommandNumberArray = new SvgCommandNumber[n];
        for (int i = 0; i < n; ++i) {
            svgCommandNumberArray[i] = (SvgCommandNumber)iterator.next();
        }
        this.arguments = Arrays.asList(svgCommandNumberArray);
    }

    private Movement(SvgCommandLetter svgCommandLetter, SvgCommandNumber ... svgCommandNumberArray) {
        this.letter = svgCommandLetter;
        this.arguments = Arrays.asList(svgCommandNumberArray);
    }

    private Movement(SvgCommandLetter svgCommandLetter) {
        this.letter = svgCommandLetter;
        this.arguments = Collections.emptyList();
    }

    public char getLetter() {
        return this.letter.getLetter();
    }

    private Movement(SvgCommandLetter svgCommandLetter, SvgPosition ... svgPositionArray) {
        this.letter = svgCommandLetter;
        SvgCommandNumber[] svgCommandNumberArray = new SvgCommandNumber[svgPositionArray.length * 2];
        for (int i = 0; i < svgPositionArray.length; ++i) {
            svgCommandNumberArray[2 * i] = svgPositionArray[i].getX();
            svgCommandNumberArray[2 * i + 1] = svgPositionArray[i].getY();
        }
        this.arguments = Arrays.asList(svgCommandNumberArray);
    }

    public Movement mutoToC(SvgPosition svgPosition) {
        if (!this.is('S')) {
            throw new UnsupportedOperationException();
        }
        if (svgPosition == null) {
            return new Movement(new SvgCommandLetter("C"), this.getSvgPosition(0), this.getSvgPosition(0), this.lastPosition());
        }
        return new Movement(new SvgCommandLetter("C"), svgPosition, this.getSvgPosition(0), this.lastPosition());
    }

    public String toSvg() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.letter.toSvg());
        stringBuilder.append(' ');
        for (SvgCommandNumber svgCommandNumber : this.arguments) {
            stringBuilder.append(svgCommandNumber.toSvg());
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public SvgPosition getSvgPosition(int n) {
        return new SvgPosition(this.arguments.get(n), this.arguments.get(n + 1));
    }

    public double getArgument(int n) {
        return this.arguments.get(n).getDouble();
    }

    public SvgPosition lastPosition() {
        if (this.letter.argumentNumber() == 0) {
            return null;
        }
        return this.getSvgPosition(this.arguments.size() - 2);
    }

    public Movement toAbsoluteUpperCase(SvgPosition svgPosition) {
        if (svgPosition == null) {
            throw new IllegalArgumentException();
        }
        if (this.letter.isUpperCase()) {
            return this;
        }
        if (this.letter.is('m')) {
            return new Movement(new SvgCommandLetter("M"), svgPosition.add(this.getSvgPosition(0)));
        }
        if (this.letter.is('l')) {
            return new Movement(new SvgCommandLetter("L"), svgPosition.add(this.getSvgPosition(0)));
        }
        if (this.letter.is('z')) {
            return new Movement(new SvgCommandLetter("Z"));
        }
        if (this.letter.is('c')) {
            return new Movement(new SvgCommandLetter("C"), svgPosition.add(this.getSvgPosition(0)), svgPosition.add(this.getSvgPosition(2)), svgPosition.add(this.getSvgPosition(4)));
        }
        if (this.letter.is('s')) {
            return new Movement(new SvgCommandLetter("S"), svgPosition.add(this.getSvgPosition(0)), svgPosition.add(this.getSvgPosition(2)));
        }
        if (this.letter.is('a')) {
            SvgPosition svgPosition2 = svgPosition.add(this.lastPosition());
            return new Movement(new SvgCommandLetter("A"), this.arguments.get(0), this.arguments.get(1), this.arguments.get(2), this.arguments.get(3), this.arguments.get(4), svgPosition2.getX(), svgPosition2.getY());
        }
        throw new UnsupportedOperationException("Movement::goUpperCase " + this.letter);
    }

    public SvgPosition getMirrorControlPoint() {
        if (this.letter.is('c')) {
            throw new IllegalStateException();
        }
        if (this.letter.is('s')) {
            throw new IllegalStateException();
        }
        if (this.letter.is('C')) {
            SvgPosition svgPosition = this.lastPosition();
            SvgPosition svgPosition2 = this.getSvgPosition(2);
            return svgPosition.getMirror(svgPosition2);
        }
        if (this.letter.is('S')) {
            SvgPosition svgPosition = this.lastPosition();
            SvgPosition svgPosition3 = this.getSvgPosition(0);
            return svgPosition.getMirror(svgPosition3);
        }
        return null;
    }

    public boolean is(char c) {
        return this.letter.is(c);
    }
}

