/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.awt.geom.Dimension2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.openiconic.SvgPath;
import net.sourceforge.plantuml.openiconic.data.DummyIcon;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class OpenIcon {
    private SvgPath svgPath;
    private List<String> rawData = new ArrayList<String>();
    private final String id;

    public static OpenIcon retrieve(String string) {
        InputStream inputStream = OpenIcon.getRessource(string);
        if (inputStream == null) {
            return null;
        }
        try {
            return new OpenIcon(inputStream, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    OpenIcon(String string) throws IOException {
        this(OpenIcon.getRessource(string), string);
    }

    private static InputStream getRessource(String string) {
        return DummyIcon.class.getResourceAsStream(string + ".svg");
    }

    private OpenIcon(InputStream inputStream, String string) throws IOException {
        this.id = string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            this.rawData.add(string2);
            if (!string2.contains("<path")) continue;
            int n = string2.indexOf(34);
            int n2 = string2.indexOf(34, n + 1);
            this.svgPath = new SvgPath(string2.substring(n + 1, n2));
        }
        bufferedReader.close();
        inputStream.close();
        if (this.rawData.size() != 3 && this.rawData.size() != 4) {
            throw new IllegalStateException();
        }
    }

    void saveCopy(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println(this.rawData.get(0));
        printWriter.println(this.svgPath.toSvg());
        printWriter.println(this.rawData.get(this.rawData.size() - 1));
        printWriter.close();
    }

    private Dimension2D getDimension(double d) {
        String string = this.getNumber(this.rawData.get(0), "width");
        String string2 = this.getNumber(this.rawData.get(0), "height");
        return new Dimension2DDouble((double)Integer.parseInt(string) * d, (double)Integer.parseInt(string2) * d);
    }

    private String getNumber(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        if ((n = string.indexOf("\"", n)) == -1) {
            throw new IllegalArgumentException();
        }
        int n2 = string.indexOf("\"", n + 1);
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        return string.substring(n + 1, n2);
    }

    public TextBlock asTextBlock(final HtmlColor htmlColor, final double d) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic) {
                OpenIcon.this.svgPath.drawMe(uGraphic.apply(new UChangeColor(htmlColor)), d);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return OpenIcon.this.getDimension(d);
            }
        };
    }
}

