/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.openiconic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.openiconic.Movement;
import net.sourceforge.plantuml.openiconic.StringDecipher;
import net.sourceforge.plantuml.openiconic.SvgCommand;
import net.sourceforge.plantuml.openiconic.SvgCommandLetter;
import net.sourceforge.plantuml.openiconic.SvgCommandNumber;
import net.sourceforge.plantuml.openiconic.SvgPosition;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;

public class SvgPath {
    private List<Movement> movements = new ArrayList<Movement>();
    private List<SvgCommand> commands = new ArrayList<SvgCommand>();

    public SvgPath(String string) {
        Object object;
        string = StringDecipher.decipher(string);
        Object object2 = new StringTokenizer(string);
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            if (((String)object).matches("[a-zA-Z]")) {
                this.commands.add(new SvgCommandLetter((String)object));
                continue;
            }
            this.commands.add(new SvgCommandNumber((String)object));
        }
        this.commands = this.manageHV(this.commands);
        this.commands = this.insertMissingLetter(this.commands);
        this.checkArguments(this.commands);
        object2 = new SvgPosition();
        object = null;
        Iterator<SvgCommand> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            Movement movement = new Movement(iterator);
            if ((movement = movement.toAbsoluteUpperCase((SvgPosition)object2)).is('S')) {
                movement = movement.mutoToC((SvgPosition)object);
            }
            this.movements.add(movement);
            if (movement.lastPosition() != null) {
                object2 = movement.lastPosition();
            }
            object = movement.getMirrorControlPoint();
        }
    }

    private List<SvgCommand> insertMissingLetter(List<SvgCommand> list) {
        ArrayList<SvgCommand> arrayList = new ArrayList<SvgCommand>();
        Iterator<SvgCommand> iterator = list.iterator();
        SvgCommandLetter svgCommandLetter = null;
        while (iterator.hasNext()) {
            int n;
            SvgCommand svgCommand = iterator.next();
            if (svgCommand instanceof SvgCommandNumber) {
                arrayList.add(svgCommandLetter);
                arrayList.add(svgCommand);
                n = svgCommandLetter.argumentNumber() - 1;
            } else {
                arrayList.add(svgCommand);
                svgCommandLetter = (SvgCommandLetter)svgCommand;
                n = svgCommandLetter.argumentNumber();
            }
            for (int i = 0; i < n; ++i) {
                SvgCommandNumber svgCommandNumber = (SvgCommandNumber)iterator.next();
                arrayList.add(svgCommandNumber);
            }
        }
        return arrayList;
    }

    private void checkArguments(List<SvgCommand> list) {
        Iterator<SvgCommand> iterator = list.iterator();
        while (iterator.hasNext()) {
            SvgCommandLetter svgCommandLetter = (SvgCommandLetter)iterator.next();
            int n = svgCommandLetter.argumentNumber();
            for (int i = 0; i < n; ++i) {
                SvgCommandNumber svgCommandNumber = (SvgCommandNumber)iterator.next();
            }
        }
    }

    private List<SvgCommand> manageHV(List<SvgCommand> list) {
        ArrayList<SvgCommand> arrayList = new ArrayList<SvgCommand>();
        SvgCommandNumber svgCommandNumber = null;
        SvgCommandNumber svgCommandNumber2 = null;
        Iterator<SvgCommand> iterator = list.iterator();
        while (iterator.hasNext()) {
            SvgCommand svgCommand = iterator.next();
            if (svgCommand instanceof SvgCommandNumber) {
                svgCommandNumber = svgCommandNumber2;
                svgCommandNumber2 = (SvgCommandNumber)svgCommand;
                arrayList.add(svgCommand);
                continue;
            }
            String string = svgCommand.toSvg();
            if (string.equals("h")) {
                arrayList.add(new SvgCommandLetter("l"));
                arrayList.add(iterator.next());
                arrayList.add(new SvgCommandNumber("0"));
                continue;
            }
            if (string.equals("v")) {
                arrayList.add(new SvgCommandLetter("l"));
                arrayList.add(new SvgCommandNumber("0"));
                arrayList.add(iterator.next());
                continue;
            }
            arrayList.add(svgCommand);
        }
        return arrayList;
    }

    public String toSvg() {
        StringBuilder stringBuilder = new StringBuilder("<path d=\"");
        for (Movement movement : this.movements) {
            stringBuilder.append(movement.toSvg());
            stringBuilder.append(' ');
        }
        stringBuilder.append("\"/>");
        return stringBuilder.toString();
    }

    private String toSvgNew() {
        StringBuilder stringBuilder = new StringBuilder("<path d=\"");
        for (SvgCommand svgCommand : this.commands) {
            stringBuilder.append(svgCommand.toSvg());
            stringBuilder.append(' ');
        }
        stringBuilder.append("\"/>");
        return stringBuilder.toString();
    }

    private UPath toUPath(double d) {
        UPath uPath = new UPath();
        for (Movement movement : this.movements) {
            char c = movement.getLetter();
            SvgPosition svgPosition = movement.lastPosition();
            if (c == 'M') {
                uPath.moveTo(svgPosition.getXDouble() * d, svgPosition.getYDouble() * d);
                continue;
            }
            if (c == 'C') {
                SvgPosition svgPosition2 = movement.getSvgPosition(0);
                SvgPosition svgPosition3 = movement.getSvgPosition(2);
                uPath.cubicTo(svgPosition2.getXDouble() * d, svgPosition2.getYDouble() * d, svgPosition3.getXDouble() * d, svgPosition3.getYDouble() * d, svgPosition.getXDouble() * d, svgPosition.getYDouble() * d);
                continue;
            }
            if (c == 'L') {
                uPath.lineTo(svgPosition.getXDouble() * d, svgPosition.getYDouble() * d);
                continue;
            }
            if (c == 'A') {
                double d2 = movement.getArgument(0);
                double d3 = movement.getArgument(1);
                double d4 = movement.getArgument(2);
                double d5 = movement.getArgument(3);
                double d6 = movement.getArgument(4);
                uPath.arcTo(d2 * d, d3 * d, d4, d5, d6, svgPosition.getXDouble() * d, svgPosition.getYDouble() * d);
                continue;
            }
            if (c == 'Z') {
                uPath.closePath();
                continue;
            }
            throw new UnsupportedOperationException("letter " + c);
        }
        uPath.setOpenIconic(true);
        return uPath;
    }

    public void drawMe(UGraphic uGraphic, double d) {
        UPath uPath = this.toUPath(d);
        uGraphic.draw(uPath);
    }
}

