/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.oregon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.oregon.Keyboard;
import net.sourceforge.plantuml.oregon.NoInputException;
import net.sourceforge.plantuml.oregon.Screen;

public class SmartKeyboard {
    private final Keyboard keyboard;
    private final List<String> history = new ArrayList<String>();

    public SmartKeyboard(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    public String input(Screen screen) throws NoInputException {
        String string = this.keyboard.input();
        this.history.add(string);
        screen.print("<i>? " + string);
        return string;
    }

    public int inputInt(Screen screen) throws NoInputException {
        String string = this.input(screen);
        if (!string.matches("\\d+")) {
            screen.print("Please enter a valid number instead of " + string);
            throw new NoInputException();
        }
        return Integer.parseInt(string);
    }

    public boolean hasMore() {
        return this.keyboard.hasMore();
    }

    public List<String> getHistory() {
        return Collections.unmodifiableList(this.history);
    }
}

