/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.png.PngSegment;

public class PngSplitter {
    private final List<File> files = new ArrayList<File>();

    public static void main(String[] stringArray) throws IOException {
        File file = new File(stringArray[0]);
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        File file2 = new File(file.getParent(), file.getName().replaceAll("\\.png$", "_000.png"));
        FileUtils.copyToFile(file, file2);
        new PngSplitter(file2, n, n2, "", 96, false);
    }

    public PngSplitter(File file, int n, int n2, String string, int n3, boolean bl) throws IOException {
        if (n == 1 && n2 == 1) {
            this.files.add(file);
            return;
        }
        Log.info("Splitting " + n + " x " + n2);
        File file2 = new File(file.getParentFile(), file.getName() + ".tmp");
        Thread.yield();
        file2.delete();
        Thread.yield();
        boolean bl2 = file.renameTo(file2);
        Thread.yield();
        if (!bl2) {
            throw new IOException("Cannot rename");
        }
        Thread.yield();
        BufferedImage bufferedImage = ImageIO.read(file2);
        Thread.yield();
        PngSegment pngSegment = new PngSegment(bufferedImage.getWidth(), n);
        PngSegment pngSegment2 = new PngSegment(bufferedImage.getHeight(), n2);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                File file3 = FileFormat.PNG.computeFilename(file, n4++);
                this.files.add(file3);
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(pngSegment.getStart(i), pngSegment2.getStart(j), pngSegment.getLen(i), pngSegment2.getLen(j));
                Thread.yield();
                PngIO.write((RenderedImage)bufferedImage2, file3, bl ? string : null, n3);
                Thread.yield();
            }
        }
        file2.delete();
        Log.info("End of splitting");
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.files);
    }
}

