/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Locale;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.Clusterable;

public class Block
implements Clusterable {
    private final int uid;
    private final double width;
    private final double height;
    private double x;
    private double y;
    private final Cluster parent;

    public Block(int n, double d, double d2, Cluster cluster) {
        this.uid = n;
        this.width = d;
        this.height = d2;
        this.parent = cluster;
    }

    public String toString() {
        return "BLOCK " + this.uid;
    }

    public String toStringPosition() {
        return String.format(Locale.US, "x=%9.2f y=%9.2f w=%9.2f h=%9.2f", this.x, this.y, this.width, this.height);
    }

    public int getUid() {
        return this.uid;
    }

    @Override
    public Cluster getParent() {
        return this.parent;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public void setCenterX(double d) {
        this.x = d - this.width / 2.0;
    }

    public void setCenterY(double d) {
        this.y = d - this.height / 2.0;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final void setY(double d) {
        this.y = d;
    }

    @Override
    public void moveSvek(double d, double d2) {
        throw new UnsupportedOperationException();
    }
}

