/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.Clusterable;
import net.sourceforge.plantuml.posimo.Label;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.posimo.Positionable;

public class SimpleDrawer {
    private final Cluster root;
    private final Collection<Path> paths;

    public SimpleDrawer(Cluster cluster, Collection<Path> collection) {
        this.root = cluster;
        this.paths = collection;
    }

    public void draw(Graphics2D graphics2D) {
        Dimension2D dimension2D;
        Point2D point2D;
        Positionable positionable;
        graphics2D.setColor(Color.BLACK);
        for (Clusterable object : this.root.getContents()) {
            positionable = (Block)object;
            point2D = ((Block)positionable).getPosition();
            dimension2D = ((Block)positionable).getSize();
            this.drawRect(graphics2D, point2D, dimension2D);
        }
        graphics2D.setColor(Color.GREEN);
        for (Path path : this.paths) {
            positionable = path.getLabel();
            point2D = ((Label)positionable).getPosition();
            dimension2D = ((Label)positionable).getSize();
            this.drawRect(graphics2D, point2D, dimension2D);
        }
        graphics2D.setColor(Color.RED);
        for (Path path : this.paths) {
            path.getDotPath().draw(graphics2D, 0.0, 0.0);
        }
        for (Cluster cluster : this.root.getSubClusters()) {
            new SimpleDrawer(cluster, new ArrayList<Path>()).draw(graphics2D);
        }
    }

    private void drawRectCentered(Graphics2D graphics2D, Point2D point2D, Dimension2D dimension2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX() - dimension2D.getWidth() / 2.0, point2D.getY() - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
        graphics2D.draw(double_);
    }

    private void drawRect(Graphics2D graphics2D, Point2D point2D, Dimension2D dimension2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
        graphics2D.draw(double_);
    }
}

