/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.IfManager;
import net.sourceforge.plantuml.preproc.PreprocessorInclude;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInsertable;
import net.sourceforge.plantuml.utils.StartUtils;

public class Preprocessor
implements ReadLine {
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final String ARG = "(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?";
    private static final Pattern definePattern = MyPattern.cmpile("^[%s]*!define[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?)(?:[%s]+(.*))?$");
    private static final Pattern undefPattern = MyPattern.cmpile("^[%s]*!undef[%s]+([A-Za-z_][A-Za-z_0-9]*)$");
    private static final Pattern definelongPattern = MyPattern.cmpile("^[%s]*!definelong[%s]+([A-Za-z_][A-Za-z_0-9]*(?:\\([A-Za-z_][A-Za-z_0-9]*(?:,[A-Za-z_][A-Za-z_0-9]*)*?\\))?)");
    private static final Pattern enddefinelongPattern = MyPattern.cmpile("^[%s]*!enddefinelong[%s]*$");
    private final Defines defines;
    private final PreprocessorInclude rawSource;
    private final ReadLineInsertable source;
    private int ignoreDefineDuringSeveralLines = 0;

    public Preprocessor(ReadLine readLine, String string, Defines defines, Set<File> set, File file) {
        this.defines = defines;
        this.defines.saveState();
        this.rawSource = new PreprocessorInclude(readLine, defines, string, set, file);
        this.source = new ReadLineInsertable(new IfManager(this.rawSource, defines));
    }

    @Override
    public String readLine() throws IOException {
        Matcher matcher;
        String string = this.source.readLine();
        if (string == null) {
            return null;
        }
        if (StartUtils.isArobaseStartDiagram(string)) {
            this.defines.restoreState();
        }
        if ((matcher = definePattern.matcher(string)).find()) {
            return this.manageDefine(matcher);
        }
        matcher = definelongPattern.matcher(string);
        if (matcher.find()) {
            return this.manageDefineLong(matcher);
        }
        matcher = undefPattern.matcher(string);
        if (matcher.find()) {
            return this.manageUndef(matcher);
        }
        if (this.ignoreDefineDuringSeveralLines > 0) {
            --this.ignoreDefineDuringSeveralLines;
            return string;
        }
        List<String> list = this.defines.applyDefines(string);
        if (list.size() > 1) {
            this.ignoreDefineDuringSeveralLines = list.size() - 2;
            this.source.insert(list.subList(1, list.size() - 1));
        }
        return list.get(0);
    }

    private String manageUndef(Matcher matcher) throws IOException {
        this.defines.undefine(matcher.group(1));
        return this.readLine();
    }

    private String manageDefineLong(Matcher matcher) throws IOException {
        String string;
        String string2 = matcher.group(1);
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if ((string = this.readLine()) == null) {
                return null;
            }
            arrayList.add(string);
        } while (!enddefinelongPattern.matcher(string).find());
        this.defines.define(string2, arrayList);
        return this.readLine();
    }

    private String manageDefine(Matcher matcher) throws IOException {
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        if (string2 == null) {
            this.defines.define(string, null);
        } else {
            Object object;
            List<String> list = this.defines.applyDefines(string2);
            if (list.size() > 1) {
                throw new UnsupportedOperationException();
            }
            StringBuilder stringBuilder = new StringBuilder(list.get(0));
            while (StringUtils.endsWithBackslash(stringBuilder.toString())) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                object = this.readLine();
                stringBuilder.append((String)object);
            }
            object = new ArrayList<String>();
            object.add(stringBuilder.toString());
            this.defines.define(string, (List<String>)object);
        }
        return this.readLine();
    }

    public int getLineNumber() {
        return this.rawSource.getLineNumber();
    }

    @Override
    public void close() throws IOException {
        this.rawSource.close();
    }
}

