/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.ReadLine;

public class UncommentReadLine
implements ReadLine {
    private final ReadLine raw;
    private final Pattern start;
    private final Pattern unpause;
    private String headerToRemove;
    private boolean paused;

    public UncommentReadLine(ReadLine readLine) {
        this.raw = readLine;
        this.start = MyPattern.cmpile("(?i)((?:\\W|\\<[^<>]*\\>)*)@start");
        this.unpause = MyPattern.cmpile("(?i)((?:\\W|\\<[^<>]*\\>)*)@unpause");
    }

    @Override
    public String readLine() throws IOException {
        Matcher matcher;
        String string = this.raw.readLine();
        if (string == null) {
            return null;
        }
        Matcher matcher2 = this.start.matcher(string);
        if (matcher2.find()) {
            this.headerToRemove = matcher2.group(1);
        }
        if (this.paused && (matcher = this.unpause.matcher(string)).find()) {
            this.headerToRemove = matcher.group(1);
        }
        if (this.headerToRemove != null && this.headerToRemove.startsWith(string)) {
            return "";
        }
        if (this.headerToRemove != null && string.startsWith(this.headerToRemove)) {
            return string.substring(this.headerToRemove.length());
        }
        return string;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }
}

