/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericNumber;
import net.sourceforge.plantuml.project.NumericType;

class Duration
implements Numeric {
    private final long minutes;

    public Duration(long l) {
        this.minutes = l;
    }

    public Duration(NumericNumber numericNumber) {
        this((long)numericNumber.getIntValue() * 24L * 60L * 60L);
    }

    @Override
    public Numeric add(Numeric numeric) {
        return new Duration(((Duration)numeric).minutes + this.minutes);
    }

    public static Duration of(long l) {
        return new Duration(l * 24L * 60L * 60L);
    }

    @Override
    public NumericType getNumericType() {
        return NumericType.DURATION;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public String toString() {
        return "DURATION:" + this.minutes / 86400L;
    }

    @Override
    public int compareTo(Numeric numeric) {
        Duration duration = (Duration)numeric;
        if (duration.minutes > this.minutes) {
            return -1;
        }
        if (duration.minutes < this.minutes) {
            return 1;
        }
        return 0;
    }
}

