/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericNumber;
import net.sourceforge.plantuml.project.NumericType;

class Load
implements Numeric {
    private final long minuteMen;

    public Load(long l) {
        this.minuteMen = l;
    }

    public Load(NumericNumber numericNumber) {
        this((long)numericNumber.getIntValue() * 24L * 60L * 60L);
    }

    @Override
    public Numeric add(Numeric numeric) {
        return new Load(((Load)numeric).minuteMen + this.minuteMen);
    }

    @Override
    public NumericType getNumericType() {
        return NumericType.LOAD;
    }

    @Override
    public int compareTo(Numeric numeric) {
        Load load = (Load)numeric;
        if (load.minuteMen > this.minuteMen) {
            return -1;
        }
        if (load.minuteMen < this.minuteMen) {
            return 1;
        }
        return 0;
    }

    public final long getMinuteMen() {
        return this.minuteMen;
    }

    public String toString() {
        return "LOAD:" + this.minuteMen / 86400L;
    }
}

