/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import net.sourceforge.plantuml.project.Numeric;
import net.sourceforge.plantuml.project.NumericType;

class NumericNumber
implements Numeric {
    private final int value;

    public NumericNumber(int n) {
        this.value = n;
    }

    @Override
    public Numeric add(Numeric numeric) {
        if (numeric.getNumericType() != this.getNumericType()) {
            throw new IllegalArgumentException();
        }
        return new NumericNumber(this.value + ((NumericNumber)numeric).value);
    }

    @Override
    public NumericType getNumericType() {
        return NumericType.NUMBER;
    }

    public int getIntValue() {
        return this.value;
    }

    public String toString() {
        return "Number:" + this.value;
    }

    @Override
    public int compareTo(Numeric numeric) {
        NumericNumber numericNumber = (NumericNumber)numeric;
        if (numericNumber.value > this.value) {
            return -1;
        }
        if (numericNumber.value < this.value) {
            return 1;
        }
        return 0;
    }
}

