/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.NumericNumber;

public class ParentItem
implements Item {
    private final String code;
    private final Item parent;
    private final List<Item> children = new ArrayList<Item>();

    public ParentItem(String string, Item item) {
        this.code = string;
        this.parent = item;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.code + " {");
        Iterator<Item> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            stringBuilder.append(item.getCode());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public Instant getBegin() {
        Instant instant = null;
        for (Item item : this.children) {
            if (instant != null && instant.compareTo(item.getBegin()) <= 0) continue;
            instant = item.getBegin();
        }
        return instant;
    }

    @Override
    public Instant getCompleted() {
        Instant instant = null;
        for (Item item : this.children) {
            if (instant != null && instant.compareTo(item.getCompleted()) >= 0) continue;
            instant = item.getCompleted();
        }
        return instant;
    }

    @Override
    public Duration getDuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Load getLoad() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericNumber getWork() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Item getParent() {
        return this.parent;
    }

    @Override
    public List<Item> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void addChild(Item item) {
        this.children.add(item);
    }

    @Override
    public boolean isValid() {
        if (this.children.size() == 0) {
            return false;
        }
        for (Item item : this.children) {
            if (item.isValid()) continue;
            return false;
        }
        return true;
    }
}

