/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.real;

import net.sourceforge.plantuml.real.PositiveForce;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealLine;
import net.sourceforge.plantuml.real.RealMoveable;

class RealImpl
extends RealMoveable {
    private final RealLine line;
    private double currentValue;

    public RealImpl(String string, RealLine realLine, double d) {
        super(string);
        this.line = realLine;
        this.currentValue = d;
    }

    @Override
    void move(double d) {
        this.currentValue += d;
    }

    @Override
    public double getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public Real addAtLeast(double d) {
        RealImpl realImpl = new RealImpl(this.getName() + ".addAtLeast" + d, this.line, this.currentValue + d);
        this.line.addForce(new PositiveForce(this, realImpl, d));
        return realImpl;
    }

    @Override
    public void ensureBiggerThan(Real real) {
        this.line.addForce(new PositiveForce(real, this, 0.0));
    }

    @Override
    public void compile() {
        this.line.compile();
    }

    @Override
    RealLine getLine() {
        return this.line;
    }
}

