/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;

public class DataSourceImpl
implements DataSource {
    private int i = 0;
    private final List<Terminated<String>> data = new ArrayList<Terminated<String>>();

    public DataSourceImpl(List<String> list) {
        Pattern pattern = MyPattern.cmpile("\\{[-+#!*/]?");
        for (String string : list) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|}", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("|")) continue;
                Terminator terminator = stringTokenizer.hasMoreTokens() ? Terminator.NEWCOL : Terminator.NEWLINE;
                Matcher matcher = pattern.matcher(string2);
                boolean bl = matcher.find();
                if (!bl) {
                    this.addInternal(string2, terminator);
                    continue;
                }
                int n = 0;
                int n2 = 0;
                do {
                    int n3;
                    if ((n3 = matcher.start()) > n) {
                        this.addInternal(string2.substring(n, n3), Terminator.NEWCOL);
                    }
                    Terminator terminator2 = (n2 = matcher.end()) == string2.length() ? terminator : Terminator.NEWCOL;
                    this.addInternal(string2.substring(n3, n2), terminator2);
                    n = n2;
                } while (matcher.find());
                if (n2 >= string2.length()) continue;
                this.addInternal(string2.substring(n2), terminator);
            }
        }
    }

    private void addInternal(String string, Terminator terminator) {
        if ((string = string.trim()).length() > 0) {
            this.data.add(new Terminated<String>(string, terminator));
        }
    }

    @Override
    public Terminated<String> peek(int n) {
        return this.data.get(this.i + n);
    }

    @Override
    public boolean hasNext() {
        return this.i < this.data.size();
    }

    @Override
    public Terminated<String> next() {
        Terminated<String> terminated = this.data.get(this.i);
        ++this.i;
        return terminated;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return super.toString() + " " + (this.hasNext() ? this.peek(0) : "$$$");
    }
}

