/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementLine;
import net.sourceforge.plantuml.salt.factory.ElementFactory;

public class ElementFactoryLine
implements ElementFactory {
    private final DataSource dataSource;

    public ElementFactoryLine(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated terminated = (Terminated)this.dataSource.next();
        String string = (String)terminated.getElement();
        return new Terminated<Element>(new ElementLine(string.charAt(0)), terminated.getTerminator());
    }

    @Override
    public boolean ready() {
        String string = this.dataSource.peek(0).getElement();
        if (this.isLine(string, '-')) {
            return true;
        }
        if (this.isLine(string, '=')) {
            return true;
        }
        if (this.isLine(string, '~')) {
            return true;
        }
        return this.isLine(string, '.');
    }

    private boolean isLine(String string, char c) {
        String string2 = "" + c + c;
        return string.startsWith(string2) && string.endsWith(string2);
    }
}

