/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementPyramid;
import net.sourceforge.plantuml.salt.element.ElementText;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;

public class ElementFactoryPyramid
extends AbstractElementFactoryComplex {
    public ElementFactoryPyramid(DataSource dataSource, Dictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        Terminated terminated;
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        String string = (String)((Terminated)this.getDataSource().next()).getElement();
        assert (string.startsWith("{"));
        TableStrategy tableStrategy = TableStrategy.DRAW_NONE;
        if (string.length() == 2) {
            tableStrategy = TableStrategy.fromChar(string.charAt(1));
        }
        Positionner2 positionner2 = new Positionner2();
        while (!this.getDataSource().peek(0).getElement().equals("}")) {
            terminated = this.getNextElement();
            if (this.isStar((Element)terminated.getElement())) {
                positionner2.mergeLeft(terminated.getTerminator());
                continue;
            }
            positionner2.add(terminated);
        }
        terminated = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(new ElementPyramid(positionner2, tableStrategy), terminated.getTerminator());
    }

    private boolean isStar(Element element) {
        if (!(element instanceof ElementText)) {
            return false;
        }
        return "*".equals(((ElementText)element).getText());
    }

    @Override
    public boolean ready() {
        String string = this.getDataSource().peek(0).getElement();
        if (string.equals("{") || string.equals("{+") || string.equals("{#") || string.equals("{!") || string.equals("{-")) {
            String string2 = this.getDataSource().peek(1).getElement();
            return !string2.matches("[NSEW]=|T");
        }
        return false;
    }
}

