/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class Note
extends AbstractEvent
implements Event,
SpecificBackcolorable {
    private final Participant p;
    private final Participant p2;
    private final Display strings;
    private final NotePosition position;
    private NoteStyle style = NoteStyle.NORMAL;
    private final Url url;
    private HtmlColor specificBackcolor;

    public Note(Participant participant, NotePosition notePosition, Display display) {
        this(participant, null, notePosition, display);
    }

    public Note(Participant participant, Participant participant2, Display display) {
        this(participant, participant2, NotePosition.OVER_SEVERAL, display);
    }

    private Note(Participant participant, Participant participant2, NotePosition notePosition, Display display) {
        this.p = participant;
        this.p2 = participant2;
        this.position = notePosition;
        if (display != null && display.size() > 0) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.STRICT);
            this.url = urlBuilder.getUrl(display.get(0).toString());
        } else {
            this.url = null;
        }
        this.strings = this.url == null ? display : display.subList(1, display.size());
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public Display getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    @Override
    public boolean dealWith(Participant participant) {
        return this.p == participant || this.p2 == participant;
    }

    @Override
    public Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public final NoteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(NoteStyle noteStyle) {
        this.style = noteStyle;
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam iSkinParam) {
        return new SkinParamBackcolored(iSkinParam, this.getSpecificBackColor());
    }
}

