/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;

public class Participant
implements SpecificBackcolorable {
    private final String code;
    private Display display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private HtmlColor liveBackcolor;
    private HtmlColor specificBackcolor;
    private Url url;

    public Participant(ParticipantType participantType, String string, Display display) {
        if (participantType == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (display == null || display.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.code = string;
        this.type = participantType;
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public Display getDisplay(boolean bl) {
        if (bl) {
            return this.display.underlined();
        }
        return this.display;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype, boolean bl) {
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        this.stereotype = stereotype;
        this.display = bl ? this.display.addFirst(stereotype) : this.display.add(stereotype);
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(HtmlColor htmlColor) {
        ++this.initialLife;
        this.liveBackcolor = htmlColor;
    }

    public HtmlColor getLiveSpecificBackColor() {
        return this.liveBackcolor;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public ColorParam getBackgroundColorParam() {
        return this.type.getBackgroundColorParam();
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam iSkinParam) {
        HtmlColor htmlColor = this.getSpecificBackColor();
        boolean bl = this.getUrl() != null;
        HtmlColor htmlColor2 = iSkinParam.getHtmlColor(this.getBackgroundColorParam(), this.getStereotype(), bl);
        if (htmlColor2 != null && htmlColor == null) {
            htmlColor = htmlColor2;
        }
        return new SkinParamBackcolored(iSkinParam, htmlColor, bl);
    }
}

