/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

public class CommandArrow
extends SingleLineCommand2<SequenceDiagram> {
    public CommandArrow() {
        super(CommandArrow.getRegexConcat());
    }

    public static String getColorOrStylePattern() {
        return "(?:\\[((?:#\\w+|dotted|dashed|bold|hidden)(?:,#\\w+|,dotted|,dashed|,bold|,hidden)*)\\])?";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PARALLEL", "(&%s*)?"), new RegexOr("PART1", new RegexLeaf("PART1CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1LONG", "[%g]([^%g]+)[%g]"), new RegexLeaf("PART1LONGCODE", "[%g]([^%g]+)[%g][%s]*as[%s]+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART1CODELONG", "([\\p{L}0-9_.@]+)[%s]+as[%s]*[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW_DRESSING1", "([%s][ox]|(?:[%s][ox])?<<?|(?:[%s][ox])?//?|(?:[%s][ox])?\\\\\\\\?)?"), new RegexOr(new RegexConcat(new RegexLeaf("ARROW_BODYA1", "(-+)"), new RegexLeaf("ARROW_STYLE1", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB1", "(-*)")), new RegexConcat(new RegexLeaf("ARROW_BODYA2", "(-*)"), new RegexLeaf("ARROW_STYLE2", CommandArrow.getColorOrStylePattern()), new RegexLeaf("ARROW_BODYB2", "(-+)"))), new RegexLeaf("ARROW_DRESSING2", "(>>?(?:[ox][%s])?|//?(?:[ox][%s])?|\\\\\\\\?(?:[ox][%s])?|[ox][%s])?"), new RegexLeaf("[%s]*"), new RegexOr("PART2", new RegexLeaf("PART2CODE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2LONG", "[%g]([^%g]+)[%g]"), new RegexLeaf("PART2LONGCODE", "[%g]([^%g]+)[%g][%s]*as[%s]+([\\p{L}0-9_.@]+)"), new RegexLeaf("PART2CODELONG", "([\\p{L}0-9_.@]+)[%s]+as[%s]*[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*"), new RegexLeaf("ACTIVATION", "(?:([+*!-]+)?)"), new RegexLeaf("[%s]*"), new RegexLeaf("LIFECOLOR", "(?:(#\\w+)?)"), new RegexLeaf("[%s]*"), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?$"));
    }

    private Participant getOrCreateParticipant(SequenceDiagram sequenceDiagram, RegexResult regexResult, String string) {
        Display display;
        String string2;
        if (regexResult.get(string + "CODE", 0) != null) {
            string2 = regexResult.get(string + "CODE", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONG", 0) != null) {
            string2 = regexResult.get(string + "LONG", 0);
            display = Display.getWithNewlines(string2);
        } else if (regexResult.get(string + "LONGCODE", 0) != null) {
            display = Display.getWithNewlines(regexResult.get(string + "LONGCODE", 0));
            string2 = regexResult.get(string + "LONGCODE", 1);
        } else {
            if (regexResult.get(string + "CODELONG", 0) != null) {
                String string3 = regexResult.get(string + "CODELONG", 0);
                Display display2 = Display.getWithNewlines(regexResult.get(string + "CODELONG", 1));
                return sequenceDiagram.getOrCreateParticipant(string3, display2);
            }
            throw new IllegalStateException();
        }
        return sequenceDiagram.getOrCreateParticipant(string2, display);
    }

    private boolean contains(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        String string;
        boolean bl;
        ArrowConfiguration arrowConfiguration;
        boolean bl2;
        boolean bl3;
        Participant participant;
        Participant participant2;
        String string2 = StringUtils.goLowerCase(CommandLinkClass.notNull(regexResult.get("ARROW_DRESSING1", 0)));
        String string3 = StringUtils.goLowerCase(CommandLinkClass.notNull(regexResult.get("ARROW_DRESSING2", 0)));
        boolean bl4 = this.contains(string3, ">", "\\", "/", "x");
        boolean bl5 = this.contains(string2, "x", "<", "\\", "/");
        if (bl4) {
            participant2 = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART1");
            participant = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART2");
            bl3 = string2.contains("o");
            bl2 = string3.contains("o");
        } else if (bl5) {
            participant = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART1");
            participant2 = this.getOrCreateParticipant(sequenceDiagram, regexResult, "PART2");
            bl3 = string3.contains("o");
            bl2 = string2.contains("o");
        } else {
            return CommandExecutionResult.error("Illegal sequence arrow");
        }
        boolean bl6 = this.contains(string2, "<<", "\\\\", "//") || this.contains(string3, ">>", "\\\\", "//");
        boolean bl7 = this.getLength(regexResult) > 1;
        Display display = regexResult.get("MESSAGE", 0) == null ? Display.create("") : Display.getWithNewlines(regexResult.get("MESSAGE", 0));
        ArrowConfiguration arrowConfiguration2 = arrowConfiguration = bl5 && bl4 ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (bl7) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (bl6) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        if (string3.contains("\\") || string2.contains("/")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.TOP_PART);
        }
        if (string3.contains("/") || string2.contains("\\")) {
            arrowConfiguration = arrowConfiguration.withPart(ArrowPart.BOTTOM_PART);
        }
        if (bl2) {
            arrowConfiguration = arrowConfiguration.withDecoration2(ArrowDecoration.CIRCLE);
        }
        if (bl3) {
            arrowConfiguration = arrowConfiguration.withDecoration1(ArrowDecoration.CIRCLE);
        }
        if (string2.contains("x")) {
            arrowConfiguration = arrowConfiguration.withHead2(ArrowHead.CROSSX);
        }
        if (string3.contains("x")) {
            arrowConfiguration = arrowConfiguration.withHead2(ArrowHead.CROSSX);
        }
        arrowConfiguration = CommandArrow.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), arrowConfiguration);
        String string4 = regexResult.get("ACTIVATION", 0);
        if (string4 != null && string4.charAt(0) == '*') {
            sequenceDiagram.activate(participant, LifeEventType.CREATE, null);
        }
        Message message = new Message(participant2, participant, display, arrowConfiguration, sequenceDiagram.getNextMessageNumber());
        boolean bl8 = bl = regexResult.get("PARALLEL", 0) != null;
        if (bl) {
            message.goParallel();
        }
        if ((string = sequenceDiagram.addMessage(message)) != null) {
            return CommandExecutionResult.error(string);
        }
        HtmlColor htmlColor = sequenceDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LIFECOLOR", 0));
        if (string4 != null) {
            switch (string4.charAt(0)) {
                case '+': {
                    sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
                    break;
                }
                case '-': {
                    sequenceDiagram.activate(participant2, LifeEventType.DEACTIVATE, null);
                    break;
                }
                case '!': {
                    sequenceDiagram.activate(participant, LifeEventType.DESTROY, null);
                    break;
                }
            }
        } else if (sequenceDiagram.isAutoactivate() && (arrowConfiguration.getHead() == ArrowHead.NORMAL || arrowConfiguration.getHead() == ArrowHead.ASYNC)) {
            if (arrowConfiguration.isDotted()) {
                sequenceDiagram.activate(participant2, LifeEventType.DEACTIVATE, null);
            } else {
                sequenceDiagram.activate(participant, LifeEventType.ACTIVATE, htmlColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private int getLength(RegexResult regexResult) {
        String string;
        String string2 = regexResult.getLazzy("ARROW_BODYA", 0);
        if (string2 == null) {
            string2 = "";
        }
        if ((string = regexResult.getLazzy("ARROW_BODYB", 0)) == null) {
            string = "";
        }
        return string2.length() + string.length();
    }

    public static ArrowConfiguration applyStyle(String string, ArrowConfiguration arrowConfiguration) {
        if (string == null) {
            return arrowConfiguration;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed") || string2.equalsIgnoreCase("bold") || string2.equalsIgnoreCase("dotted") || string2.equalsIgnoreCase("hidden")) continue;
            arrowConfiguration = arrowConfiguration.withColor(HtmlColorSet.getInstance().getColorIfValid(string2));
        }
        return arrowConfiguration;
    }
}

