/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.ugraphic.UFont;

public abstract class CommandParticipant
extends SingleLineCommand2<SequenceDiagram> {
    public CommandParticipant(RegexConcat regexConcat) {
        super(regexConcat);
    }

    static IRegex getRegexType() {
        return new RegexOr(new RegexLeaf("TYPE", "(participant|actor|create|boundary|control|entity|database)"), new RegexLeaf("CREATE", "create[%s](participant|actor|boundary|control|entity|database)"));
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        String string;
        Object object;
        Object object2;
        boolean bl;
        ParticipantType participantType;
        String string2 = regexResult.get("CODE", 0);
        if (sequenceDiagram.participants().containsKey(string2)) {
            sequenceDiagram.putParticipantInLast(string2);
            return CommandExecutionResult.ok();
        }
        Display display = null;
        if (regexResult.get("FULL", 0) != null) {
            display = Display.getWithNewlines(regexResult.get("FULL", 0));
        }
        String string3 = regexResult.get("TYPE", 0);
        String string4 = regexResult.get("CREATE", 0);
        if (string4 != null) {
            participantType = ParticipantType.valueOf(StringUtils.goUpperCase(string4));
            bl = true;
        } else if (string3.equalsIgnoreCase("CREATE")) {
            participantType = ParticipantType.PARTICIPANT;
            bl = true;
        } else {
            participantType = ParticipantType.valueOf(StringUtils.goUpperCase(string3));
            bl = false;
        }
        Participant participant = sequenceDiagram.createNewParticipant(participantType, string2, display);
        String string5 = regexResult.get("STEREO", 0);
        if (string5 != null) {
            object2 = sequenceDiagram.getSkinParam();
            boolean bl2 = object2.stereotypePositionTop();
            object = object2.getFont(FontParam.CIRCLED_CHARACTER, null, false);
            participant.setStereotype(new Stereotype(string5, object2.getCircledCharacterRadius(), (UFont)object, sequenceDiagram.getSkinParam().getIHtmlColorSet()), bl2);
        }
        participant.setSpecificBackcolor(sequenceDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        object2 = regexResult.get("URL", 0);
        if (object2 != null) {
            UrlBuilder urlBuilder = new UrlBuilder(sequenceDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = urlBuilder.getUrl((String)object2);
            participant.setUrl((Url)object);
        }
        if (bl && (string = sequenceDiagram.activate(participant, LifeEventType.CREATE, null)) != null) {
            return CommandExecutionResult.error(string);
        }
        return CommandExecutionResult.ok();
    }
}

