/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Arrays;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;

class FrontierComplex
implements Frontier {
    private final double[] freeY;

    public FrontierComplex(double d, int n) {
        this.freeY = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.freeY[i] = d;
        }
    }

    private FrontierComplex(double[] dArray) {
        this.freeY = dArray;
    }

    private FrontierComplex(double[] dArray, double d, ParticipantRange participantRange) {
        this((double[])dArray.clone());
        double d2 = this.getFreeY(participantRange) + d;
        for (int i = participantRange.start(); i <= participantRange.end(); ++i) {
            this.freeY[i] = d2;
        }
    }

    @Override
    public double getFreeY(ParticipantRange participantRange) {
        if (participantRange == null) {
            throw new IllegalArgumentException();
        }
        double d = this.freeY[participantRange.start()];
        for (int i = participantRange.start(); i <= participantRange.end(); ++i) {
            if (!(this.freeY[i] > d)) continue;
            d = this.freeY[i];
        }
        return d;
    }

    public String toString() {
        return Arrays.toString(this.freeY);
    }

    @Override
    public FrontierComplex add(double d, ParticipantRange participantRange) {
        if (participantRange == null) {
            throw new IllegalArgumentException();
        }
        return new FrontierComplex(this.freeY, d, participantRange);
    }

    FrontierComplex copy() {
        return new FrontierComplex((double[])this.freeY.clone());
    }

    FrontierComplex mergeMax(FrontierComplex frontierComplex) {
        if (this.freeY.length != frontierComplex.freeY.length) {
            throw new IllegalArgumentException();
        }
        FrontierComplex frontierComplex2 = new FrontierComplex(new double[this.freeY.length]);
        for (int i = 0; i < this.freeY.length; ++i) {
            frontierComplex2.freeY[i] = Math.max(this.freeY[i], frontierComplex.freeY[i]);
        }
        return frontierComplex2;
    }
}

