/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierComplex;
import net.sourceforge.plantuml.sequencediagram.graphic.FrontierStack;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;

class FrontierStackImpl
implements FrontierStack {
    private final List<Stack> all;

    public FrontierStackImpl(double d, int n) {
        Stack stack = new Stack(new FrontierComplex(d, n));
        this.all = Collections.singletonList(stack);
    }

    private FrontierStackImpl(List<Stack> list) {
        this.all = Collections.unmodifiableList(list);
    }

    private FrontierComplex getLast() {
        return this.all.get(this.all.size() - 1).current;
    }

    @Override
    public double getFreeY(ParticipantRange participantRange) {
        return this.getLast().getFreeY(participantRange);
    }

    @Override
    public FrontierStackImpl add(double d, ParticipantRange participantRange) {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack = new Stack(this.getLast().add(d, participantRange));
        arrayList.set(arrayList.size() - 1, stack);
        return new FrontierStackImpl(arrayList);
    }

    @Override
    public FrontierStack openBar() {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack = new Stack(this.getLast().copy());
        arrayList.add(stack);
        return new FrontierStackImpl(arrayList);
    }

    @Override
    public FrontierStack restore() {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack = (Stack)arrayList.get(arrayList.size() - 2);
        Stack stack2 = (Stack)arrayList.get(arrayList.size() - 1);
        arrayList.set(arrayList.size() - 2, stack.addEnvelop(stack2.current));
        arrayList.remove(arrayList.size() - 1);
        Stack stack3 = new Stack(stack.current.copy());
        arrayList.add(stack3);
        return new FrontierStackImpl(arrayList);
    }

    @Override
    public FrontierStack closeBar() {
        ArrayList<Stack> arrayList = new ArrayList<Stack>(this.all);
        Stack stack = (Stack)arrayList.get(arrayList.size() - 2);
        Stack stack2 = (Stack)arrayList.get(arrayList.size() - 1);
        Stack stack3 = stack.addEnvelop(stack2.current);
        arrayList.set(arrayList.size() - 2, new Stack(stack3.envelop));
        arrayList.remove(arrayList.size() - 1);
        return new FrontierStackImpl(arrayList);
    }

    public FrontierStackImpl copy() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "nb=" + this.all.size() + " " + this.getLast().toString();
    }

    class Stack {
        private final FrontierComplex current;
        private final FrontierComplex envelop;

        Stack(FrontierComplex frontierComplex) {
            this(frontierComplex, null);
        }

        private Stack(FrontierComplex frontierComplex, FrontierComplex frontierComplex2) {
            this.current = frontierComplex;
            this.envelop = frontierComplex2;
        }

        Stack addEnvelop(FrontierComplex frontierComplex) {
            if (this.envelop == null) {
                return new Stack(this.current, frontierComplex);
            }
            return new Stack(this.current, this.envelop.mergeMax(frontierComplex));
        }
    }
}

