/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class GraphicalReference
extends GraphicalElement
implements InGroupable {
    private final Component comp;
    private final LivingParticipantBox livingParticipantBox1;
    private final LivingParticipantBox livingParticipantBox2;
    private final Url url;

    public GraphicalReference(double d, Component component, LivingParticipantBox livingParticipantBox, LivingParticipantBox livingParticipantBox2, Url url) {
        super(d);
        if (livingParticipantBox == null || livingParticipantBox2 == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.comp = component;
        this.livingParticipantBox1 = livingParticipantBox;
        this.livingParticipantBox2 = livingParticipantBox2;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d2 = this.getMinX(stringBounder);
        uGraphic = uGraphic.apply(new UTranslate(d2, this.getStartingY()));
        double d3 = this.comp.getPreferredWidth(stringBounder);
        double d4 = this.getMaxX(stringBounder) - this.getMinX(stringBounder);
        double d5 = Math.max(d3, d4);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d5, this.comp.getPreferredHeight(stringBounder));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        this.comp.drawU(uGraphic, new Area(dimension2DDouble), context2D);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.comp.getPreferredWidth(stringBounder);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.getMinX(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return Math.max(this.livingParticipantBox1.getMaxX(stringBounder), this.livingParticipantBox2.getMaxX(stringBounder));
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return Math.min(this.livingParticipantBox1.getMinX(stringBounder), this.livingParticipantBox2.getMinX(stringBounder));
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }
}

