/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;

abstract class GroupingGraphicalElement
extends GraphicalElement {
    private final InGroupableList inGroupableList;

    public GroupingGraphicalElement(double d, InGroupableList inGroupableList) {
        super(d);
        this.inGroupableList = inGroupableList;
        if (inGroupableList == null) {
            throw new IllegalArgumentException();
        }
    }

    public final double getActualWidth(StringBounder stringBounder) {
        return Math.max(this.getPreferredWidth(stringBounder), this.inGroupableList.getMaxX(stringBounder) - this.inGroupableList.getMinX(stringBounder) + 20.0);
    }

    @Override
    public final double getStartingX(StringBounder stringBounder) {
        return this.inGroupableList.getMinX(stringBounder) - 10.0;
    }

    protected final InGroupableList getInGroupableList() {
        return this.inGroupableList;
    }
}

