/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class MessageSelfArrow
extends Arrow {
    private final LivingParticipantBox p1;
    private final double deltaX;
    private final double deltaY;

    public MessageSelfArrow(double d, Skin skin, Component component, LivingParticipantBox livingParticipantBox, double d2, Url url, double d3) {
        super(d, skin, component, url);
        this.p1 = livingParticipantBox;
        this.deltaY = d2;
        this.deltaX = d3;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getArrowComponent().getPreferredWidth(stringBounder);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UTranslate(this.getStartingX(stringBounder), this.getStartingY() + this.deltaY));
        Area area = new Area(new Dimension2DDouble(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder)));
        area.setDeltaX1(this.deltaY);
        this.startUrl(uGraphic);
        this.getArrowComponent().drawU(uGraphic, area, context2D);
        this.endUrl(uGraphic);
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        double d = this.p1.getLiveThicknessAt(stringBounder, this.getArrowYStartLevel(stringBounder)).getSegment().getPos2();
        return d + this.deltaX;
    }

    @Override
    public int getDirection(StringBounder stringBounder) {
        return 1;
    }

    @Override
    public double getArrowYStartLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getStartPoint(stringBounder, dimension2DDouble).getY();
        }
        return this.getStartingY();
    }

    @Override
    public double getArrowYEndLevel(StringBounder stringBounder) {
        if (this.getArrowComponent() instanceof ArrowComponent) {
            ArrowComponent arrowComponent = (ArrowComponent)this.getArrowComponent();
            Dimension2DDouble dimension2DDouble = new Dimension2DDouble(arrowComponent.getPreferredWidth(stringBounder), arrowComponent.getPreferredHeight(stringBounder));
            return this.getStartingY() + arrowComponent.getEndPoint(stringBounder, dimension2DDouble).getY();
        }
        return this.getStartingY() + this.getArrowComponent().getPreferredHeight(stringBounder);
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder) + this.getPreferredWidth(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        return this.getStartingX(stringBounder);
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return super.toString();
    }

    @Override
    public LivingParticipantBox getParticipantAt(StringBounder stringBounder, NotePosition notePosition) {
        return this.p1;
    }

    @Override
    public double getActualWidth(StringBounder stringBounder) {
        return this.getPreferredWidth(stringBounder);
    }
}

