/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

final class NotesBoxes
extends GraphicalElement
implements InGroupable {
    private final List<NoteBox> notes = new ArrayList<NoteBox>();
    private final List<ParticipantBox> participants1 = new ArrayList<ParticipantBox>();
    private final List<ParticipantBox> participants2 = new ArrayList<ParticipantBox>();

    NotesBoxes(double d) {
        super(d);
    }

    public void add(NoteBox noteBox, ParticipantBox participantBox, ParticipantBox participantBox2) {
        this.notes.add(noteBox);
        this.participants1.add(participantBox);
        if (participantBox2 == null) {
            this.participants2.add(participantBox);
        } else {
            this.participants2.add(participantBox2);
        }
    }

    public void ensureConstraints(StringBounder stringBounder, ConstraintSet constraintSet) {
        for (int i = 0; i < this.notes.size(); ++i) {
            NoteBox noteBox = this.notes.get(i);
            ParticipantBox participantBox = this.participants1.get(i);
            ParticipantBox participantBox2 = this.participants2.get(i);
            double d = noteBox.getPreferredWidth(stringBounder);
            constraintSet.getConstraintBefore(participantBox).ensureValue(d / 2.0);
            constraintSet.getConstraintAfter(participantBox2).ensureValue(d / 2.0);
            for (int j = i + 1; j < this.notes.size(); ++j) {
                NoteBox noteBox2 = this.notes.get(j);
                ParticipantBox participantBox3 = this.participants1.get(j);
                double d2 = noteBox2.getPreferredWidth(stringBounder);
                constraintSet.getConstraint(participantBox2, participantBox3).ensureValue((d + d2) / 2.0);
            }
        }
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        double d = Double.MAX_VALUE;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getMinX(stringBounder);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getMaxX(stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        for (NoteBox noteBox : this.notes) {
            noteBox.drawInternalU(uGraphic, d, context2D);
        }
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        double d = Double.MAX_VALUE;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getStartingX(stringBounder);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getMaxX(stringBounder) - this.getMinX(stringBounder);
        return d;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (NoteBox noteBox : this.notes) {
            double d2 = noteBox.getPreferredHeight(stringBounder);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }
}

