/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSetInitializer;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.PageSplitter;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramArea;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class SequenceDiagramFileMakerPuma2
implements FileMaker {
    private static final StringBounder dummyStringBounder = TextBlockUtils.getDummyStringBounder();
    private final SequenceDiagram diagram;
    private final DrawableSet drawableSet;
    private final Dimension2D fullDimension;
    private final List<Page> pages;
    private final FileFormatOption fileFormatOption;
    private double scale;

    public SequenceDiagramFileMakerPuma2(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption) {
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        DrawableSetInitializer drawableSetInitializer = new DrawableSetInitializer(skin, sequenceDiagram.getSkinParam(), sequenceDiagram.isShowFootbox(), sequenceDiagram.getAutonewpage());
        for (Participant object22 : sequenceDiagram.participants().values()) {
            drawableSetInitializer.addParticipant(object22, sequenceDiagram.getEnglober(object22));
        }
        for (Event event : sequenceDiagram.events()) {
            drawableSetInitializer.addEvent(event);
        }
        this.drawableSet = drawableSetInitializer.createDrawableSet(dummyStringBounder);
        ArrayList arrayList = new ArrayList();
        for (Event event : this.drawableSet.getAllEvents()) {
            if (!(event instanceof Newpage)) continue;
            arrayList.add((Newpage)event);
        }
        this.fullDimension = this.drawableSet.getDimension();
        LinkedHashMap<Newpage, Double> linkedHashMap = new LinkedHashMap<Newpage, Double>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Newpage newpage = (Newpage)iterator.next();
            linkedHashMap.put(newpage, drawableSetInitializer.getYposition(dummyStringBounder, newpage));
        }
        this.pages = this.create(this.drawableSet, linkedHashMap, sequenceDiagram.isShowFootbox(), sequenceDiagram.getTitle()).getPages();
    }

    @Override
    public int getNbPages() {
        return this.pages.size();
    }

    private PageSplitter create(DrawableSet drawableSet, Map<Newpage, Double> map, boolean bl, Display display) {
        double d = drawableSet.getHeadHeight(dummyStringBounder);
        double d2 = drawableSet.getTailHeight(dummyStringBounder, bl);
        double d3 = drawableSet.getSkin().createComponent(ComponentType.NEWPAGE, null, drawableSet.getSkinParam(), Display.create("")).getPreferredHeight(dummyStringBounder);
        return new PageSplitter(this.fullDimension.getHeight(), d, map, d2, 0.0, d3, display);
    }

    @Override
    public ImageData createOne(OutputStream outputStream, final int n, boolean bl) throws IOException {
        Component component;
        final Page page = this.pages.get(n);
        final SequenceDiagramArea sequenceDiagramArea = new SequenceDiagramArea(this.fullDimension.getWidth(), page.getHeight());
        if (page.getTitle() == null) {
            component = null;
        } else {
            component = this.drawableSet.getSkin().createComponent(ComponentType.TITLE, null, this.drawableSet.getSkinParam(), page.getTitle());
            sequenceDiagramArea.setTitleArea(component.getPreferredWidth(dummyStringBounder), component.getPreferredHeight(dummyStringBounder));
        }
        this.addFooter2(sequenceDiagramArea);
        this.addHeader2(sequenceDiagramArea);
        final Display display = this.diagram.getLegend();
        final TextBlock textBlock = display == null ? TextBlockUtils.empty(0.0, 0.0) : EntityImageLegend.create(display, this.diagram.getSkinParam());
        final Dimension2D dimension2D = TextBlockUtils.getDimension(textBlock);
        this.scale = this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight());
        double d = this.diagram.getDpiFactor(this.fileFormatOption);
        ImageBuilder imageBuilder = new ImageBuilder(this.diagram.getSkinParam().getColorMapper(), this.oneOf(this.scale, d), this.diagram.getSkinParam().getBackgroundColor(), null, null, 3.0, 10.0, this.diagram.getAnimation(), this.diagram.getSkinParam().handwritten());
        imageBuilder.addUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic uGraphic) {
                double d;
                double d2 = 0.0;
                if (n > 0) {
                    d2 = page.getNewpage1() - page.getHeaderHeight();
                }
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                double d3 = 0.0;
                if (component != null) {
                    StringBounder stringBounder = uGraphic.getStringBounder();
                    double d4 = component.getPreferredHeight(stringBounder);
                    d3 += d4;
                    d = component.getPreferredWidth(stringBounder);
                    component.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getTitleX(), sequenceDiagramArea.getTitleY())), new Area(new Dimension2DDouble(d, d4)), new SimpleContext2D(false));
                }
                double d5 = Math.max(0.0, dimension2D.getWidth() - sequenceDiagramArea.getWidth());
                boolean bl = display != null && SequenceDiagramFileMakerPuma2.this.diagram.getLegendVerticalAlignment() == VerticalAlignment.TOP;
                d = sequenceDiagramArea.getSequenceAreaY();
                if (bl) {
                    d += textBlock.calculateDimension(uGraphic.getStringBounder()).getHeight();
                }
                SequenceDiagramFileMakerPuma2.this.drawableSet.drawU22(uGraphic.apply(new UTranslate(sequenceDiagramArea.getSequenceAreaX() + d5 / 2.0, d)), d2, SequenceDiagramFileMakerPuma2.this.fullDimension.getWidth(), page, SequenceDiagramFileMakerPuma2.this.diagram.isShowFootbox());
                SequenceDiagramFileMakerPuma2.this.addHeader3(sequenceDiagramArea, uGraphic);
                SequenceDiagramFileMakerPuma2.this.addFooter3(sequenceDiagramArea, uGraphic);
                if (display != null) {
                    double d6 = SequenceDiagramFileMakerPuma2.this.diagram.getLegendAlignment() == HorizontalAlignment.LEFT ? 0.0 : (SequenceDiagramFileMakerPuma2.this.diagram.getLegendAlignment() == HorizontalAlignment.RIGHT ? Math.max(0.0, sequenceDiagramArea.getWidth() - dimension2D.getWidth()) : Math.max(0.0, sequenceDiagramArea.getWidth() - dimension2D.getWidth()) / 2.0);
                    textBlock.drawU(uGraphic.apply(new UTranslate(d6, bl ? d3 : d3 + sequenceDiagramArea.getHeight())));
                }
            }
        });
        return imageBuilder.writeImageTOBEMOVED(this.fileFormatOption.getFileFormat(), outputStream);
    }

    private double oneOf(double d, double d2) {
        if (d == 1.0) {
            return d2;
        }
        return d;
    }

    private double getImageWidth(SequenceDiagramArea sequenceDiagramArea, double d, double d2) {
        int n = this.diagram.getMinwidth();
        double d3 = Math.max(sequenceDiagramArea.getWidth() * this.getScale(sequenceDiagramArea.getWidth(), sequenceDiagramArea.getHeight()) * d, d2);
        if (n == Integer.MAX_VALUE) {
            return d3;
        }
        if (d3 >= (double)n) {
            return d3;
        }
        return n;
    }

    private double getScale(double d, double d2) {
        if (this.diagram.getScale() == null) {
            return 1.0;
        }
        return this.diagram.getScale().getScale(d, d2);
    }

    private void addFooter2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null, false).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null, false).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignment(), htmlColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setFooterArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addHeader2(SequenceDiagramArea sequenceDiagramArea) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null, false).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null, false).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignment(), htmlColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        Dimension2D dimension2D = pngTitler.getTextDimension(dummyStringBounder);
        if (dimension2D != null) {
            sequenceDiagramArea.setHeaderArea(dimension2D.getWidth(), dimension2D.getHeight(), 3.0);
        }
    }

    private void addFooter3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null, false).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null, false).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignment(), htmlColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getFooterX(this.diagram.getFooterAlignment()), sequenceDiagramArea.getFooterY())));
    }

    private void addHeader3(SequenceDiagramArea sequenceDiagramArea, UGraphic uGraphic) {
        HtmlColor htmlColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null, false).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null, false).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignment(), htmlColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        TextBlock textBlock = pngTitler.getTextBlock();
        if (textBlock == null) {
            return;
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(sequenceDiagramArea.getHeaderX(this.diagram.getHeaderAlignment()), sequenceDiagramArea.getHeaderY())));
    }
}

