/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTile
implements TileWithUpdateStairs {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Message message;
    private final Skin skin;
    private final ISkinParam skinParam;
    public static final double LIVE_DELTA_SIZE = 5.0;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public CommunicationTile(LivingSpace livingSpace, LivingSpace livingSpace2, Message message, Skin skin, ISkinParam iSkinParam) {
        if (livingSpace == livingSpace2) {
            throw new IllegalArgumentException();
        }
        this.livingSpace1 = livingSpace;
        this.livingSpace2 = livingSpace2;
        this.message = message;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public boolean isReverse(StringBounder stringBounder) {
        Real real = this.livingSpace1.getPosC(stringBounder);
        Real real2 = this.livingSpace2.getPosC(stringBounder);
        return real.getCurrentValue() > real2.getCurrentValue();
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.isReverse(stringBounder)) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        Component component = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabel());
        return component;
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double d) {
        ArrowComponent arrowComponent = (ArrowComponent)this.getComponent(stringBounder);
        Dimension2D dimension2D = arrowComponent.getPreferredDimension(stringBounder);
        double d2 = arrowComponent.getStartPoint(stringBounder, dimension2D).getY();
        this.livingSpace1.addStepForLivebox(this.getEvent(), d + d2);
        this.livingSpace2.addStepForLivebox(this.getEvent(), d + d2);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Area area;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getPoint1(stringBounder).getCurrentValue();
        double d2 = this.getPoint2(stringBounder).getCurrentValue();
        int n = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
        int n2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
        if (this.isReverse(stringBounder)) {
            System.err.println("isreverse!");
            area = new Area(d - (d2 += 5.0 * (double)n2), dimension2D.getHeight());
            uGraphic = uGraphic.apply(new UTranslate(d2, 0.0));
        } else {
            area = new Area((d2 -= 5.0 * (double)n2) - (d += 5.0 * (double)n), dimension2D.getHeight());
            uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        }
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        Real real = this.getPoint1(stringBounder);
        Real real2 = this.getPoint2(stringBounder);
        if (real.getCurrentValue() < real2.getCurrentValue()) {
            real2.ensureBiggerThan(real.addFixed(d));
        } else {
            real.ensureBiggerThan(real2.addFixed(d));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    private Real getPoint2(StringBounder stringBounder) {
        if (this.message.isCreate()) {
            if (this.isReverse(stringBounder)) {
                return this.livingSpace2.getPosD(stringBounder);
            }
            return this.livingSpace2.getPosB();
        }
        return this.livingSpace2.getPosC(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint2(stringBounder);
        }
        return this.getPoint1(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint1(stringBounder);
        }
        return this.getPoint2(stringBounder);
    }
}

