/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class DelayTile
implements Tile {
    private final Delay delay;
    private final TileArguments tileArguments;
    private Real first;
    private Real last;

    @Override
    public Event getEvent() {
        return this.delay;
    }

    public DelayTile(Delay delay, TileArguments tileArguments) {
        this.delay = delay;
        this.tileArguments = tileArguments;
    }

    private void init(StringBounder stringBounder) {
        if (this.first != null) {
            return;
        }
        this.first = this.tileArguments.getFirstLivingSpace().getPosC(stringBounder);
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        this.last = this.tileArguments.getLastLivingSpace().getPosC(stringBounder).addAtLeast(0.0);
        this.last.ensureBiggerThan(this.first.addFixed(dimension2D.getWidth()));
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.tileArguments.getSkin().createComponent(ComponentType.DELAY_TEXT, null, this.tileArguments.getSkinParam(), this.delay.getText());
        return component;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        this.init(stringBounder);
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Area area = new Area(this.last.getCurrentValue() - this.first.getCurrentValue(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(this.first.getCurrentValue(), 0.0));
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.first;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.last;
    }
}

