/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class DividerTile
implements Tile {
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Divider divider;
    private final Real origin;
    private final Real omega;

    @Override
    public Event getEvent() {
        return this.divider;
    }

    public DividerTile(Divider divider, Skin skin, ISkinParam iSkinParam, Real real, Real real2) {
        this.divider = divider;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.origin = real;
        this.omega = real2;
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.DIVIDER, null, this.skinParam, this.divider.getText());
        return component;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Area area = new Area(this.omega.getCurrentValue() - this.origin.getCurrentValue(), dimension2D.getHeight());
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.origin;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.omega;
    }
}

