/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.Stairs2;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;

public class EventsHistory {
    private final Participant p;
    private final List<Event> events;
    private final Map<Event, Double> ys3 = new HashMap<Event, Double>();

    public EventsHistory(Participant participant, List<Event> list) {
        this.p = participant;
        this.events = list;
    }

    public void addStepForLivebox(Event event, double d) {
        this.ys3.put(event, d);
    }

    public Participant getParticipant() {
        return this.p;
    }

    public int getLevelAt(Event event, EventsHistoryMode eventsHistoryMode) {
        int n = this.getLevelAtInternal(event, eventsHistoryMode);
        return n;
    }

    private int getLevelAtInternal(Event event, EventsHistoryMode eventsHistoryMode) {
        int n = 0;
        Iterator<Event> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            Event event2;
            Event event3 = iterator.next();
            if (event3 instanceof LifeEvent) {
                event2 = (LifeEvent)event3;
                if (((LifeEvent)event2).getParticipant() == this.p && ((LifeEvent)event2).isActivate()) {
                    ++n;
                }
                if (((LifeEvent)event2).getParticipant() == this.p && ((LifeEvent)event2).isDeactivateOrDestroy()) {
                    --n;
                }
            }
            if (event != event3) continue;
            if (event3 instanceof Message && (event2 = this.nextButSkippingNotes(iterator)) instanceof LifeEvent) {
                LifeEvent lifeEvent = (LifeEvent)event2;
                Message message = (Message)event3;
                if (eventsHistoryMode != EventsHistoryMode.IGNORE_FUTURE_ACTIVATE && lifeEvent.isActivate() && message.dealWith(this.p) && lifeEvent.getParticipant() == this.p) {
                    ++n;
                }
                if (eventsHistoryMode == EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE && lifeEvent.isDeactivateOrDestroy() && message.dealWith(this.p) && lifeEvent.getParticipant() == this.p) {
                    --n;
                }
            }
            return n;
        }
        throw new IllegalArgumentException();
    }

    private boolean isNextEventADestroy(Event event) {
        Iterator<Event> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            Event event2;
            Event event3 = iterator.next();
            if (event != event3) continue;
            if (event3 instanceof Message && (event2 = this.nextButSkippingNotes(iterator)) instanceof LifeEvent) {
                LifeEvent lifeEvent = (LifeEvent)event2;
                return lifeEvent.isDestroy();
            }
            return false;
        }
        return false;
    }

    private HtmlColor getActivateColor(Event event) {
        Iterator<Event> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            Event event2;
            Event event3 = iterator.next();
            if (event != event3) continue;
            if (event3 instanceof Message && (event2 = this.nextButSkippingNotes(iterator)) instanceof LifeEvent) {
                LifeEvent lifeEvent = (LifeEvent)event2;
                if (lifeEvent.isActivate()) {
                    return lifeEvent.getSpecificBackColor();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Event nextButSkippingNotes(Iterator<Event> iterator) {
        Event event;
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((event = iterator.next()) instanceof Note);
        return event;
    }

    public Stairs2 getStairs(double d) {
        System.err.println("EventsHistory::getStairs totalHeight=" + d);
        Stairs2 stairs2 = new Stairs2();
        int n = 0;
        for (Event event : this.events) {
            Double d2 = this.ys3.get(event);
            System.err.println("EventsHistory::getStairs event=" + event + " position=" + d2);
            if (d2 == null) continue;
            assert (d2 <= d) : "position=" + d2 + " totalHeight=" + d;
            n = this.getLevelAt(event, EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE);
            stairs2.addStep(new StairsPosition(d2, this.isNextEventADestroy(event)), n, this.getActivateColor(event));
        }
        System.err.println("EventsHistory::getStairs finishing totalHeight=" + d);
        stairs2.addStep(new StairsPosition(d, false), n, null);
        return stairs2;
    }
}

