/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMax;
import net.sourceforge.plantuml.real.RealMin;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GroupingTile
implements Tile {
    private static final int MARGINX = 16;
    private static final int MARGINY = 10;
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final RealMin min = new RealMin();
    private final RealMax max = new RealMax();
    private final GroupingStart start;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Display display;
    private double bodyHeight;

    @Override
    public Event getEvent() {
        return this.start;
    }

    public GroupingTile(Iterator<Event> iterator, GroupingStart groupingStart, TileArguments tileArguments, TileArguments tileArguments2) {
        Object object;
        StringBounder stringBounder = tileArguments2.getStringBounder();
        this.start = groupingStart;
        this.display = groupingStart.getTitle().equals("group") ? Display.create(groupingStart.getComment()) : Display.create(groupingStart.getTitle(), groupingStart.getComment());
        this.skin = tileArguments2.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        while (iterator.hasNext()) {
            object = iterator.next();
            System.err.println("GroupingTile::ev=" + object);
            if (object instanceof GroupingLeaf && ((Grouping)object).getType() == GroupingType.END) break;
            Tile tile = TileBuilder.buildOne(iterator, tileArguments2, (Event)object, this);
            if (tile == null) continue;
            this.tiles.add(tile);
            this.min.put(tile.getMinX(stringBounder).addFixed(-16.0));
            Real real = tile.getMaxX(stringBounder);
            this.max.put(real == tileArguments2.getOmega() ? real : real.addFixed(16.0));
            this.bodyHeight += tile.getPreferredHeight(stringBounder);
        }
        object = this.getPreferredDimensionIfEmpty(stringBounder);
        double d = ((Dimension2D)object).getWidth();
        System.err.println("width=" + d);
        if (this.min.size() == 0) {
            this.min.put(tileArguments2.getOrigin());
            this.max.put(tileArguments2.getOmega());
        }
        this.max.ensureBiggerThan(this.getMinX(stringBounder).addFixed(d + 16.0));
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.GROUPING_HEADER, null, this.skinParam, this.display);
        return component;
    }

    public Dimension2D getPreferredDimensionIfEmpty(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), this.bodyHeight + dimension2D.getHeight() + 5.0);
        if (!(uGraphic instanceof LiveBoxFinder)) {
            component.drawU(uGraphic.apply(new UTranslate(this.min.getCurrentValue(), 0.0)), area, (Context2D)((Object)uGraphic));
        }
        double d = dimension2D.getHeight() + 5.0;
        for (Tile tile : this.tiles) {
            uGraphic.apply(new UTranslate(0.0, d)).draw(tile);
            d += tile.getPreferredHeight(stringBounder);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        return dimension2D.getHeight() + this.bodyHeight + 10.0;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }
}

