/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Iterator;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistory;
import net.sourceforge.plantuml.sequencediagram.teoz.IntegerColored;
import net.sourceforge.plantuml.sequencediagram.teoz.Stairs2;
import net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxes
implements UDrawable {
    private final EventsHistory eventsHistory;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final double totalHeight;
    private final Context2D context;

    public LiveBoxes(EventsHistory eventsHistory, Skin skin, ISkinParam iSkinParam, double d, Context2D context2D) {
        this.eventsHistory = eventsHistory;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.totalHeight = d;
        this.context = context2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Stairs2 stairs2 = this.eventsHistory.getStairs(this.totalHeight);
        int n = stairs2.getMaxValue();
        for (int i = 1; i <= n; ++i) {
            this.drawOneLevel(uGraphic, i, stairs2, this.context);
        }
    }

    private void drawOneLevel(UGraphic uGraphic, int n, Stairs2 stairs2, Context2D context2D) {
        Component component = this.skin.createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, this.skinParam, null);
        Component component2 = this.skin.createComponent(ComponentType.DESTROY, null, this.skinParam, null);
        Dimension2D dimension2D = component2.getPreferredDimension(uGraphic.getStringBounder());
        double d = component.getPreferredWidth(uGraphic.getStringBounder());
        uGraphic = uGraphic.apply(new UTranslate((double)(n - 1) * d / 2.0, 0.0));
        double d2 = Double.MAX_VALUE;
        HtmlColor htmlColor = null;
        Iterator<StairsPosition> iterator = stairs2.getYs().iterator();
        while (iterator.hasNext()) {
            StairsPosition stairsPosition = iterator.next();
            System.err.println("LiveBoxes::drawOneLevel " + n + " " + stairsPosition);
            IntegerColored integerColored = stairs2.getValue(stairsPosition.getValue());
            System.err.println("integerColored=" + integerColored);
            int n2 = integerColored.getValue();
            if (d2 == Double.MAX_VALUE && n2 == n) {
                d2 = stairsPosition.getValue();
                htmlColor = integerColored.getColor();
                continue;
            }
            if (d2 == Double.MAX_VALUE || iterator.hasNext() && n2 >= n) continue;
            double d3 = stairsPosition.getValue();
            Area area = new Area(d, d3 - d2);
            SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.skinParam, htmlColor);
            Component component3 = this.skin.createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, skinParamBackcolored, null);
            component3.drawU(uGraphic.apply(new UTranslate(-d / 2.0, d2)), area, context2D);
            System.err.println("LiveBoxes::drawOneLevel one block " + d2 + " " + d3);
            if (stairsPosition.isDestroy()) {
                System.err.println("LiveBoxes::drawOneLevel DESTROY " + stairsPosition);
                component2.drawU(uGraphic.apply(new UTranslate(-dimension2D.getWidth() / 2.0, d3 - dimension2D.getHeight() / 2.0)), null, context2D);
            } else {
                System.err.println("LiveBoxes::drawOneLevel NOTDESTROY " + stairsPosition);
            }
            d2 = Double.MAX_VALUE;
        }
    }

    private UGraphic withColor(UGraphic uGraphic) {
        return uGraphic;
    }
}

