/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LivingSpaces {
    private final Map<Participant, LivingSpace> all = new LinkedHashMap<Participant, LivingSpace>();

    public Collection<LivingSpace> values() {
        return this.all.values();
    }

    public void put(Participant participant, LivingSpace livingSpace) {
        this.all.put(participant, livingSpace);
    }

    public LivingSpace get(Participant participant) {
        return this.all.get(participant);
    }

    public void drawHeads(UGraphic uGraphic, Context2D context2D, VerticalAlignment verticalAlignment) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getHeadHeight(stringBounder);
        for (LivingSpace livingSpace : this.values()) {
            double d2 = livingSpace.getPosB().getCurrentValue();
            double d3 = 0.0;
            if (verticalAlignment == VerticalAlignment.BOTTOM) {
                Dimension2D dimension2D = livingSpace.getHeadPreferredDimension(stringBounder);
                d3 = d - dimension2D.getHeight();
            }
            livingSpace.drawHead(uGraphic.apply(new UTranslate(d2, d3)), context2D);
        }
    }

    public double getHeadHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (LivingSpace livingSpace : this.values()) {
            Dimension2D dimension2D = livingSpace.getHeadPreferredDimension(stringBounder);
            d = Math.max(d, dimension2D.getHeight());
        }
        return d;
    }

    public void drawLifeLines(UGraphic uGraphic, double d, Context2D context2D) {
        boolean bl = false;
        for (LivingSpace livingSpace : this.values()) {
            double d2 = livingSpace.getPosC(uGraphic.getStringBounder()).getCurrentValue();
            livingSpace.drawLineAndLiveBoxes(uGraphic.apply(new UTranslate(d2, 0.0)), d, context2D);
        }
    }
}

