/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMax;
import net.sourceforge.plantuml.real.RealMin;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.sequencediagram.teoz.UGraphicInterceptorTile;
import net.sourceforge.plantuml.sequencediagram.teoz.YPositionedTile;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class MainTile
implements Tile {
    private final RealMin min = new RealMin();
    private final RealMax max = new RealMax();
    private final List<Tile> tiles = new ArrayList<Tile>();

    public MainTile(SequenceDiagram sequenceDiagram, Skin skin, Real real, LivingSpaces livingSpaces, Real real2) {
        this.min.put(real2);
        this.max.put(real);
        ISkinParam iSkinParam = sequenceDiagram.getSkinParam();
        StringBounder stringBounder = TextBlockUtils.getDummyStringBounder();
        TileArguments tileArguments = new TileArguments(stringBounder, real, livingSpaces, skin, iSkinParam, real2);
        this.tiles.addAll(TileBuilder.buildSeveral(sequenceDiagram.events().iterator(), tileArguments, null));
        for (Tile tile : this.tiles) {
            this.min.put(tile.getMinX(stringBounder));
            this.max.put(tile.getMaxX(stringBounder));
        }
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        LiveBoxFinder liveBoxFinder = new LiveBoxFinder(stringBounder);
        this.drawUInternal(liveBoxFinder, false);
        UGraphicInterceptorTile uGraphicInterceptorTile = new UGraphicInterceptorTile(uGraphic, true);
        this.drawUInternal(uGraphicInterceptorTile, false);
    }

    public void drawForeground(UGraphic uGraphic) {
        UGraphicInterceptorTile uGraphicInterceptorTile = new UGraphicInterceptorTile(uGraphic, false);
        this.drawUInternal(uGraphicInterceptorTile, false);
    }

    private double drawUInternal(UGraphic uGraphic, boolean bl) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = 0.0;
        double d2 = 0.0;
        ArrayList<YPositionedTile> arrayList = new ArrayList<YPositionedTile>();
        for (Tile uDrawable : this.tiles) {
            if (uDrawable.getEvent().isParallel()) {
                d = d2;
            }
            if (bl) {
                System.err.println("MainTile::drawUInternal tile=" + uDrawable + " y=" + d);
            }
            arrayList.add(new YPositionedTile(uDrawable, d));
            d2 = d;
            d += uDrawable.getPreferredHeight(stringBounder);
        }
        for (YPositionedTile yPositionedTile : arrayList) {
            yPositionedTile.drawU(uGraphic);
        }
        System.err.println("MainTile::drawUInternal finalY=" + d);
        return d;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, true);
        UGraphicInterceptorTile uGraphicInterceptorTile = new UGraphicInterceptorTile(limitFinder, false);
        double d = this.drawUInternal(uGraphicInterceptorTile, true);
        double d2 = Math.max(limitFinder.getMinMax().getDimension().getHeight(), d) + 10.0;
        System.err.println("MainTile::getPreferredHeight=" + d2);
        return d2;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }

    @Override
    public Event getEvent() {
        return null;
    }
}

