/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.png.PngTitler;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.MainTile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.utils.MathUtils;

public class SequenceDiagramFileMakerTeoz
implements FileMaker {
    private final SequenceDiagram diagram;
    private final FileFormatOption fileFormatOption;
    private final Skin skin;

    public SequenceDiagramFileMakerTeoz(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption) {
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        this.skin = skin;
    }

    @Override
    public ImageData createOne(OutputStream outputStream, int n, boolean bl) throws IOException {
        double d;
        UGraphic uGraphic;
        StringBounder stringBounder = TextBlockUtils.getDummyStringBounder();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        Real real = RealUtils.createOrigin();
        Real real2 = real.addAtLeast(0.0);
        LivingSpace livingSpace = null;
        LivingSpaces livingSpaces = new LivingSpaces();
        for (Participant participant : this.diagram.participants().values()) {
            LivingSpace livingSpace2;
            livingSpace = livingSpace2 = new LivingSpace(participant, this.diagram.getEnglober(participant), this.skin, iSkinParam, real2, this.diagram.events());
            livingSpaces.put(participant, livingSpace2);
            real2 = livingSpace2.getPosD(stringBounder).addAtLeast(0.0);
        }
        MainTile mainTile = new MainTile(this.diagram, this.skin, livingSpace.getPosD(stringBounder).addAtLeast(0.0), livingSpaces, real);
        mainTile.addConstraints(stringBounder);
        real.compile();
        double d2 = mainTile.getPreferredHeight(stringBounder) + 2.0 * livingSpaces.getHeadHeight(stringBounder);
        Real real3 = mainTile.getMinX(stringBounder);
        Real real4 = mainTile.getMaxX(stringBounder);
        Component component = this.getCompTitle();
        double d3 = real4.getCurrentValue() - real3.getCurrentValue();
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        if (component != null) {
            dimension2D = component.getPreferredDimension(stringBounder);
        }
        PngTitler pngTitler = this.getFooter();
        Dimension2D dimension2D2 = new Dimension2DDouble(0.0, 0.0);
        if (pngTitler != null && pngTitler.getTextBlock() != null) {
            dimension2D2 = pngTitler.getTextBlock().calculateDimension(stringBounder);
        }
        PngTitler pngTitler2 = this.getHeader();
        Dimension2D dimension2D3 = new Dimension2DDouble(0.0, 0.0);
        if (pngTitler2 != null && pngTitler2.getTextBlock() != null) {
            dimension2D3 = pngTitler2.getTextBlock().calculateDimension(stringBounder);
        }
        double d4 = MathUtils.max(d3, dimension2D.getWidth(), dimension2D2.getWidth(), dimension2D3.getWidth());
        double d5 = d2 + dimension2D.getHeight() + dimension2D3.getHeight() + dimension2D2.getHeight();
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d4, d5);
        UGraphic2 uGraphic2 = (UGraphic2)this.fileFormatOption.createUGraphic(iSkinParam.getColorMapper(), this.diagram.getDpiFactor(this.fileFormatOption), dimension2DDouble, iSkinParam.getBackgroundColor(), false).apply(new UTranslate(-real3.getCurrentValue(), 0.0));
        UGraphic uGraphic3 = uGraphic = this.diagram.getSkinParam().handwritten() ? new UGraphicHandwritten(uGraphic2) : uGraphic2;
        if (pngTitler != null && pngTitler.getTextBlock() != null) {
            d = 0.0;
            if (this.diagram.getFooterAlignment() == HorizontalAlignment.RIGHT) {
                d = d4 - dimension2D2.getWidth();
            } else if (this.diagram.getFooterAlignment() == HorizontalAlignment.CENTER) {
                d = (d4 - dimension2D2.getWidth()) / 2.0;
            }
            pngTitler.getTextBlock().drawU(uGraphic.apply(new UTranslate(d, d2 + dimension2D.getHeight() + dimension2D3.getHeight())));
        }
        if (pngTitler2 != null && pngTitler2.getTextBlock() != null) {
            d = 0.0;
            if (this.diagram.getHeaderAlignment() == HorizontalAlignment.RIGHT) {
                d = d4 - dimension2D3.getWidth();
            } else if (this.diagram.getHeaderAlignment() == HorizontalAlignment.CENTER) {
                d = (d4 - dimension2D3.getWidth()) / 2.0;
            }
            pngTitler2.getTextBlock().drawU(uGraphic.apply(new UTranslate(d, 0.0)));
        }
        if (component != null) {
            component.drawU(uGraphic.apply(new UTranslate((d4 - dimension2D.getWidth()) / 2.0, 0.0)), new Area(dimension2D), new SimpleContext2D(false));
            uGraphic = uGraphic.apply(new UTranslate((d4 - d3) / 2.0, dimension2D.getHeight() + dimension2D3.getHeight()));
        }
        this.drawMainTile(uGraphic, mainTile, livingSpaces);
        uGraphic2.writeImageTOBEMOVED(outputStream, bl ? this.diagram.getMetadata() : null, this.diagram.getDpi(this.fileFormatOption));
        Dimension2DDouble dimension2DDouble2 = new Dimension2DDouble(((Dimension2D)dimension2DDouble).getWidth(), ((Dimension2D)dimension2DDouble).getHeight());
        return new ImageDataSimple(dimension2DDouble2);
    }

    private Component getCompTitle() {
        Display display = this.diagram.getTitle();
        Component component = display == null ? null : this.skin.createComponent(ComponentType.TITLE, null, this.diagram.getSkinParam(), display);
        return component;
    }

    private PngTitler getFooter() {
        if (this.diagram.getFooter() == null) {
            return null;
        }
        HtmlColor htmlColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.FOOTER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null, false).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.FOOTER, null, false).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, this.diagram.getFooter(), n, string, this.diagram.getFooterAlignment(), htmlColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        return pngTitler;
    }

    private PngTitler getHeader() {
        HtmlColor htmlColor = this.diagram.getSkinParam().getHyperlinkColor();
        HtmlColor htmlColor2 = this.diagram.getSkinParam().getFontHtmlColor(FontParam.HEADER, null);
        String string = this.diagram.getSkinParam().getFont(FontParam.HEADER, null, false).getFamily(null);
        int n = this.diagram.getSkinParam().getFont(FontParam.HEADER, null, false).getSize();
        PngTitler pngTitler = new PngTitler(htmlColor2, this.diagram.getHeader(), n, string, this.diagram.getHeaderAlignment(), htmlColor, this.diagram.getSkinParam().useUnderlineForHyperlink());
        return pngTitler;
    }

    private void drawMainTile(UGraphic uGraphic, MainTile mainTile, LivingSpaces livingSpaces) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        SimpleContext2D simpleContext2D = new SimpleContext2D(false);
        livingSpaces.drawHeads(uGraphic, simpleContext2D, VerticalAlignment.BOTTOM);
        double d = livingSpaces.getHeadHeight(stringBounder);
        mainTile.drawU(uGraphic.apply(new UTranslate(0.0, d)));
        livingSpaces.drawLifeLines(uGraphic.apply(new UTranslate(0.0, d)), mainTile.getPreferredHeight(stringBounder), simpleContext2D);
        livingSpaces.drawHeads(uGraphic.apply(new UTranslate(0.0, mainTile.getPreferredHeight(stringBounder) + d)), simpleContext2D, VerticalAlignment.TOP);
        mainTile.drawForeground(uGraphic.apply(new UTranslate(0.0, d)));
    }

    @Override
    public int getNbPages() {
        return 1;
    }
}

