/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SkinParamBackcoloredReference;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.skin.Skin;

public class TileArguments {
    private final StringBounder stringBounder;
    private final Real omega;
    private final Real origin;
    private final LivingSpaces livingSpaces;
    private final Skin skin;
    private final ISkinParam skinParam;

    public TileArguments(StringBounder stringBounder, Real real, LivingSpaces livingSpaces, Skin skin, ISkinParam iSkinParam, Real real2) {
        this.stringBounder = stringBounder;
        this.origin = real2;
        this.omega = real;
        this.livingSpaces = livingSpaces;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    public TileArguments withBackColorGeneral(HtmlColor htmlColor, HtmlColor htmlColor2) {
        return new TileArguments(this.stringBounder, this.omega, this.livingSpaces, this.skin, new SkinParamBackcolored(this.skinParam, htmlColor, htmlColor2), this.origin);
    }

    public TileArguments withBackColor(Reference reference) {
        SkinParamBackcoloredReference skinParamBackcoloredReference = new SkinParamBackcoloredReference(this.skinParam, reference.getBackColorElement(), reference.getBackColorGeneral());
        return new TileArguments(this.stringBounder, this.omega, this.livingSpaces, this.skin, skinParamBackcoloredReference, this.origin);
    }

    public final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public final Real getOmega() {
        return this.omega;
    }

    public final Real getOrigin() {
        return this.origin;
    }

    public final LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    public final Skin getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public LivingSpace getLivingSpace(Participant participant) {
        return this.livingSpaces.get(participant);
    }

    public LivingSpace getFirstLivingSpace() {
        return this.livingSpaces.values().iterator().next();
    }

    public LivingSpace getLastLivingSpace() {
        LivingSpace livingSpace = null;
        Iterator<LivingSpace> iterator = this.livingSpaces.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace livingSpace2;
            livingSpace = livingSpace2 = iterator.next();
        }
        return livingSpace;
    }
}

