/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationExoTile;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTile;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteLeft;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteRight;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelf;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelfNoteRight;
import net.sourceforge.plantuml.sequencediagram.teoz.DelayTile;
import net.sourceforge.plantuml.sequencediagram.teoz.DividerTile;
import net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LifeEventTile;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.NoteTile;
import net.sourceforge.plantuml.sequencediagram.teoz.ReferenceTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Skin;

public class TileBuilder {
    public static List<Tile> buildSeveral(Iterator<Event> iterator, TileArguments tileArguments, Tile tile) {
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        while (iterator.hasNext()) {
            Event event = iterator.next();
            Tile tile2 = TileBuilder.buildOne(iterator, tileArguments, event, tile);
            if (tile2 == null) continue;
            arrayList.add(tile2);
            tileArguments.getOmega().ensureBiggerThan(tile2.getMaxX(tileArguments.getStringBounder()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Tile buildOne(Iterator<Event> iterator, TileArguments tileArguments, Event event, Tile tile) {
        StringBounder stringBounder = tileArguments.getStringBounder();
        Skin skin = tileArguments.getSkin();
        ISkinParam iSkinParam = tileArguments.getSkinParam();
        LivingSpaces livingSpaces = tileArguments.getLivingSpaces();
        Tile tile2 = null;
        if (event instanceof Message) {
            Message message = (Message)event;
            LivingSpace livingSpace = livingSpaces.get(message.getParticipant1());
            LivingSpace livingSpace2 = livingSpaces.get(message.getParticipant2());
            boolean bl = false;
            if (message.isSelfMessage()) {
                tile2 = new CommunicationTileSelf(livingSpace, message, skin, iSkinParam, livingSpaces);
            } else {
                tile2 = new CommunicationTile(livingSpace, livingSpace2, message, skin, iSkinParam);
                bl = ((CommunicationTile)tile2).isReverse(stringBounder);
            }
            if (message.getNote() != null) {
                NotePosition notePosition = message.getNotePosition();
                if (notePosition == NotePosition.LEFT) {
                    tile2 = new CommunicationTileNoteLeft((TileWithUpdateStairs)tile2, message, skin, iSkinParam, bl ? livingSpace2 : livingSpace);
                } else if (notePosition == NotePosition.RIGHT && message.isSelfMessage()) {
                    tile2 = new CommunicationTileSelfNoteRight((CommunicationTileSelf)tile2, message, skin, iSkinParam);
                } else if (notePosition == NotePosition.RIGHT) {
                    tile2 = new CommunicationTileNoteRight((TileWithUpdateStairs)tile2, message, skin, iSkinParam, bl ? livingSpace : livingSpace2);
                }
            }
        } else if (event instanceof MessageExo) {
            MessageExo messageExo = (MessageExo)event;
            LivingSpace livingSpace = livingSpaces.get(messageExo.getParticipant());
            tile2 = new CommunicationExoTile(livingSpace, messageExo, skin, iSkinParam, tileArguments.getOrigin(), tileArguments.getOmega());
            if (messageExo.getNote() != null) {
                NotePosition notePosition = messageExo.getNotePosition();
                if (notePosition == NotePosition.LEFT) {
                    tile2 = new CommunicationTileNoteLeft((TileWithUpdateStairs)tile2, messageExo, skin, iSkinParam, livingSpace);
                } else if (notePosition == NotePosition.RIGHT) {
                    tile2 = new CommunicationTileNoteRight((TileWithUpdateStairs)tile2, messageExo, skin, iSkinParam, livingSpace);
                }
            }
        } else if (event instanceof Note) {
            Note note = (Note)event;
            LivingSpace livingSpace = livingSpaces.get(note.getParticipant());
            LivingSpace livingSpace3 = note.getParticipant2() == null ? null : livingSpaces.get(note.getParticipant2());
            tile2 = new NoteTile(livingSpace, livingSpace3, note, skin, iSkinParam);
        } else if (event instanceof Divider) {
            Divider divider = (Divider)event;
            tile2 = new DividerTile(divider, skin, iSkinParam, tileArguments.getOrigin(), tileArguments.getOmega());
        } else if (event instanceof GroupingStart) {
            GroupingStart groupingStart = (GroupingStart)event;
            tile2 = new GroupingTile(iterator, groupingStart, tileArguments.withBackColorGeneral(groupingStart.getBackColorElement(), groupingStart.getBackColorGeneral()), tileArguments);
        } else if (event instanceof GroupingLeaf && ((GroupingLeaf)event).getType() == GroupingType.ELSE) {
            GroupingLeaf groupingLeaf = (GroupingLeaf)event;
            tile2 = new ElseTile(groupingLeaf, skin, iSkinParam, tile);
        } else if (event instanceof Reference) {
            Reference reference = (Reference)event;
            tile2 = new ReferenceTile(reference, tileArguments.withBackColor(reference));
        } else if (event instanceof Delay) {
            Delay delay = (Delay)event;
            tile2 = new DelayTile(delay, tileArguments);
        } else if (event instanceof LifeEvent) {
            LifeEvent lifeEvent = (LifeEvent)event;
            LivingSpace livingSpace = livingSpaces.get(lifeEvent.getParticipant());
            tile2 = new LifeEventTile(lifeEvent, tileArguments, livingSpace, skin, iSkinParam);
        } else {
            System.err.println("TileBuilder::Ignoring " + event.getClass());
        }
        return tile2;
    }
}

