/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseLine
extends AbstractComponent {
    private final HtmlColor color;
    private final boolean continueLine;
    private final UStroke stroke;

    public ComponentRoseLine(HtmlColor htmlColor, boolean bl, UStroke uStroke) {
        this.color = htmlColor;
        this.continueLine = bl;
        this.stroke = uStroke;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic = uGraphic.apply(new UChangeColor(this.color));
        uGraphic = this.continueLine ? uGraphic.apply(new UStroke()) : this.stroke(uGraphic, 5.0, 5.0, this.stroke.getThickness());
        int n = (int)(dimension2D.getWidth() / 2.0);
        uGraphic.apply(new UTranslate(n, 0.0)).draw(new ULine(0.0, dimension2D.getHeight()));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

