/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class ComponentRoseNote
extends AbstractTextualComponent
implements Stencil {
    private final int cornersize = 10;
    private final double paddingX;
    private final double paddingY;
    private final SymbolContext symbolContext;

    public ComponentRoseNote(SymbolContext symbolContext, FontConfiguration fontConfiguration, Display display, double d, double d2, ISkinSimple iSkinSimple) {
        super(display, fontConfiguration, HorizontalAlignment.LEFT, 6, 15, 5, iSkinSimple, 0.0, true, null, null);
        this.paddingX = d;
        this.paddingY = d2;
        this.symbolContext = symbolContext;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder) + 2.0 * this.getPaddingX() + this.symbolContext.getDeltaShadow();
        return d;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY() + this.symbolContext.getDeltaShadow();
    }

    @Override
    public double getPaddingX() {
        return this.paddingX;
    }

    @Override
    public double getPaddingY() {
        return this.paddingY;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)this.getTextWidth(stringBounder);
        double d = area.getDimensionToUse().getWidth() - this.getPreferredWidth(stringBounder);
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        if (area.getDimensionToUse().getWidth() > this.getPreferredWidth(stringBounder)) {
            n2 = (int)(area.getDimensionToUse().getWidth() - 2.0 * this.getPaddingX());
        }
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, n);
        uPolygon.addPoint(n2, n);
        uPolygon.addPoint(n2, 10.0);
        uPolygon.addPoint(n2 - 10, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.setDeltaShadow(this.symbolContext.getDeltaShadow());
        uGraphic = this.symbolContext.apply(uGraphic);
        uGraphic.draw(uPolygon);
        uGraphic.apply(new UTranslate(n2 - 10, 0.0)).draw(new ULine(0.0, 10.0));
        uGraphic.apply(new UTranslate(n2, 10.0)).draw(new ULine(-10.0, 0.0));
        UGraphic uGraphic2 = new UGraphicStencil(uGraphic, this, new UStroke());
        uGraphic2 = uGraphic2.apply(new UTranslate((double)this.getMarginX1() + d / 2.0, this.getMarginY()));
        this.getTextBlock().drawU(uGraphic2);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double d) {
        return this.getTextWidth(stringBounder);
    }
}

