/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseBoundary;
import net.sourceforge.plantuml.skin.rose.ComponentRoseControl;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDatabase;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEntity;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteBox;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteHexagonal;
import net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseTitle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Rose
implements Skin {
    private final double paddingX = 5.0;
    private final double paddingY = 5.0;

    public HtmlColor getFontColor(ISkinParam iSkinParam, FontParam fontParam) {
        return iSkinParam.getFontHtmlColor(fontParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam) {
        return this.getHtmlColor(iSkinParam, colorParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam, Stereotype stereotype) {
        HtmlColor htmlColor = iSkinParam.getHtmlColor(colorParam, stereotype, false);
        if (htmlColor == null && (htmlColor = colorParam.getDefaultValue()) == null) {
            throw new IllegalArgumentException();
        }
        return htmlColor;
    }

    private FontConfiguration getUFont2(ISkinParam iSkinParam, FontParam fontParam) {
        UFont uFont = iSkinParam.getFont(fontParam, null, false);
        HtmlColor htmlColor = this.getFontColor(iSkinParam, fontParam);
        return new FontConfiguration(uFont, htmlColor, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
    }

    @Override
    public Component createComponent(ComponentType componentType, ArrowConfiguration arrowConfiguration, ISkinParam iSkinParam, Display display) {
        UFont uFont = iSkinParam.getFont(FontParam.SEQUENCE_GROUP, null, false);
        UFont uFont2 = iSkinParam.getFont(FontParam.SEQUENCE_STEREOTYPE, null, false);
        if (componentType.isArrow()) {
            HtmlColor htmlColor;
            HtmlColor htmlColor2 = htmlColor = arrowConfiguration.getColor() == null ? this.getHtmlColor(iSkinParam, ColorParam.sequenceArrow) : arrowConfiguration.getColor();
            if (arrowConfiguration.getArrowDirection() == ArrowDirection.SELF) {
                return new ComponentRoseSelfArrow(htmlColor, this.getUFont2(iSkinParam, FontParam.SEQUENCE_ARROW), display, arrowConfiguration, (ISkinSimple)iSkinParam, iSkinParam.maxMessageSize(), !iSkinParam.strictUmlStyle());
            }
            HorizontalAlignment horizontalAlignment = iSkinParam.getHorizontalAlignment(AlignParam.SEQUENCE_MESSAGE_ALIGN);
            HorizontalAlignment horizontalAlignment2 = iSkinParam.getHorizontalAlignment(AlignParam.SEQUENCE_MESSAGETEXT_ALIGN);
            return new ComponentRoseArrow(htmlColor, this.getUFont2(iSkinParam, FontParam.SEQUENCE_ARROW), display, arrowConfiguration, horizontalAlignment, iSkinParam, horizontalAlignment2, iSkinParam.maxMessageSize(), !iSkinParam.strictUmlStyle());
        }
        if (componentType == ComponentType.PARTICIPANT_HEAD) {
            return new ComponentRoseParticipant(this.getSymbolContext(iSkinParam, ColorParam.participantBorder), this.getUFont2(iSkinParam, FontParam.PARTICIPANT), display, iSkinParam, iSkinParam.getRoundCorner(), uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.PARTICIPANT_TAIL) {
            return new ComponentRoseParticipant(this.getSymbolContext(iSkinParam, ColorParam.participantBorder), this.getUFont2(iSkinParam, FontParam.PARTICIPANT), display, iSkinParam, iSkinParam.getRoundCorner(), uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            HtmlColor htmlColor = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor, false, Rose.getStroke(iSkinParam, LineParam.sequenceLifeLineBorder, 1.0));
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            HtmlColor htmlColor = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor, true, Rose.getStroke(iSkinParam, LineParam.sequenceLifeLineBorder, 1.5));
        }
        if (componentType == ComponentType.ACTOR_HEAD) {
            return new ComponentRoseActor(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, true, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.ACTOR_TAIL) {
            return new ComponentRoseActor(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, false, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.BOUNDARY_HEAD) {
            return new ComponentRoseBoundary(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, true, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.BOUNDARY_TAIL) {
            return new ComponentRoseBoundary(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, false, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.CONTROL_HEAD) {
            return new ComponentRoseControl(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, true, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.CONTROL_TAIL) {
            return new ComponentRoseControl(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, false, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.ENTITY_HEAD) {
            return new ComponentRoseEntity(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, true, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.ENTITY_TAIL) {
            return new ComponentRoseEntity(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, false, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.DATABASE_HEAD) {
            return new ComponentRoseDatabase(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, true, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.DATABASE_TAIL) {
            return new ComponentRoseDatabase(this.getSymbolContext(iSkinParam, ColorParam.actorBorder), this.getUFont2(iSkinParam, FontParam.ACTOR), display, false, iSkinParam, uFont2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_STEREOTYPE));
        }
        if (componentType == ComponentType.NOTE) {
            return new ComponentRoseNote(this.getSymbolContext(iSkinParam, ColorParam.noteBorder), this.getUFont2(iSkinParam, FontParam.NOTE), display, 5.0, 5.0, iSkinParam);
        }
        if (componentType == ComponentType.NOTE_HEXAGONAL) {
            return new ComponentRoseNoteHexagonal(this.getSymbolContext(iSkinParam, ColorParam.noteBorder), this.getUFont2(iSkinParam, FontParam.NOTE), display, iSkinParam);
        }
        if (componentType == ComponentType.NOTE_BOX) {
            return new ComponentRoseNoteBox(this.getSymbolContext(iSkinParam, ColorParam.noteBorder), this.getUFont2(iSkinParam, FontParam.NOTE), display, iSkinParam);
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            return new ComponentRoseGroupingHeader(iSkinParam.getBackgroundColor(), this.getSymbolContext(iSkinParam, ColorParam.sequenceGroupBorder), this.getUFont2(iSkinParam, FontParam.SEQUENCE_GROUP_HEADER), uFont, display, iSkinParam);
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBorder), this.getUFont2(iSkinParam, FontParam.SEQUENCE_GROUP), display.get(0), iSkinParam, iSkinParam.getBackgroundColor());
        }
        if (componentType == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentRoseActiveLine(this.getSymbolContext(iSkinParam, ColorParam.sequenceLifeLineBorder), true, true);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentRoseActiveLine(this.getSymbolContext(iSkinParam, ColorParam.sequenceLifeLineBorder), true, false);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentRoseActiveLine(this.getSymbolContext(iSkinParam, ColorParam.sequenceLifeLineBorder), false, true);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentRoseActiveLine(this.getSymbolContext(iSkinParam, ColorParam.sequenceLifeLineBorder), false, false);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            return new ComponentRoseDelayLine(this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder));
        }
        if (componentType == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(this.getUFont2(iSkinParam, FontParam.SEQUENCE_DELAY), display, iSkinParam);
        }
        if (componentType == ComponentType.DESTROY) {
            return new ComponentRoseDestroy(this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder));
        }
        if (componentType == ComponentType.NEWPAGE) {
            return new ComponentRoseNewpage(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP));
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(this.getUFont2(iSkinParam, FontParam.SEQUENCE_DIVIDER), this.getHtmlColor(iSkinParam, ColorParam.sequenceDividerBackground), display, iSkinParam, this.deltaShadow(iSkinParam) > 0.0, Rose.getStroke(iSkinParam, LineParam.sequenceDividerBorder, 2.0));
        }
        if (componentType == ComponentType.REFERENCE) {
            return new ComponentRoseReference(this.getUFont2(iSkinParam, FontParam.SEQUENCE_REFERENCE), this.getSymbolContext(iSkinParam, ColorParam.sequenceReferenceBorder), this.getUFont2(iSkinParam, FontParam.SEQUENCE_GROUP_HEADER), display, iSkinParam.getHorizontalAlignment(AlignParam.SEQUENCE_REFERENCE_ALIGN), iSkinParam, this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBackground));
        }
        if (componentType == ComponentType.TITLE) {
            return new ComponentRoseTitle(this.getUFont2(iSkinParam, FontParam.SEQUENCE_TITLE), display, iSkinParam);
        }
        if (componentType == ComponentType.SIGNATURE) {
            return new ComponentRoseTitle(uFont.toFont2(HtmlColorUtils.BLACK, iSkinParam.useUnderlineForHyperlink(), iSkinParam.getHyperlinkColor()), Display.create("This skin was created ", "in April 2009."), iSkinParam);
        }
        if (componentType == ComponentType.ENGLOBER) {
            return new ComponentRoseEnglober(this.getSymbolContext(iSkinParam, ColorParam.sequenceBoxBorder), display, this.getUFont2(iSkinParam, FontParam.SEQUENCE_BOX), iSkinParam);
        }
        return null;
    }

    private double deltaShadow(ISkinParam iSkinParam) {
        return iSkinParam.shadowing() ? 4.0 : 0.0;
    }

    private SymbolContext getSymbolContext(ISkinParam iSkinParam, ColorParam colorParam) {
        if (colorParam == ColorParam.participantBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.participantBackground), this.getHtmlColor(iSkinParam, ColorParam.participantBorder)).withStroke(Rose.getStroke(iSkinParam, LineParam.sequenceParticipantBorder, 1.5)).withDeltaShadow(this.deltaShadow(iSkinParam));
        }
        if (colorParam == ColorParam.actorBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.actorBackground), this.getHtmlColor(iSkinParam, ColorParam.actorBorder)).withStroke(Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0)).withDeltaShadow(this.deltaShadow(iSkinParam));
        }
        if (colorParam == ColorParam.sequenceLifeLineBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBackground), this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder)).withDeltaShadow(this.deltaShadow(iSkinParam));
        }
        if (colorParam == ColorParam.noteBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.noteBackground), this.getHtmlColor(iSkinParam, ColorParam.noteBorder)).withStroke(Rose.getStroke(iSkinParam, LineParam.noteBorder, 1.0)).withDeltaShadow(this.deltaShadow(iSkinParam));
        }
        if (colorParam == ColorParam.sequenceGroupBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBackground), this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBorder)).withStroke(Rose.getStroke(iSkinParam, LineParam.sequenceGroupBorder, 2.0)).withDeltaShadow(this.deltaShadow(iSkinParam));
        }
        if (colorParam == ColorParam.sequenceBoxBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBackground), this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBorder));
        }
        if (colorParam == ColorParam.sequenceReferenceBorder) {
            return new SymbolContext(this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceHeaderBackground), this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBorder)).withStroke(Rose.getStroke(iSkinParam, LineParam.sequenceReferenceBorder, 2.0)).withDeltaShadow(this.deltaShadow(iSkinParam));
        }
        throw new IllegalArgumentException();
    }

    public static UStroke getStroke(ISkinParam iSkinParam, LineParam lineParam, double d) {
        UStroke uStroke = iSkinParam.getThickness(lineParam, null);
        if (uStroke == null) {
            return new UStroke(d);
        }
        return uStroke;
    }

    @Override
    public Object getProtocolVersion() {
        return 1;
    }
}

