/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class StateDiagram
extends AbstractEntityDiagram {
    private boolean hideEmptyDescription = false;

    public boolean checkConcurrentStateOk(Code code) {
        if (!this.leafExist(code)) {
            return true;
        }
        ILeaf iLeaf = this.getLeafsget(code);
        if (this.getCurrentGroup().getGroupType() == GroupType.CONCURRENT_STATE && this.getCurrentGroup() != iLeaf.getParentContainer()) {
            return false;
        }
        return iLeaf.getParentContainer().getGroupType() != GroupType.CONCURRENT_STATE || this.getCurrentGroup() == iLeaf.getParentContainer();
    }

    @Override
    public IEntity getOrCreateLeaf(Code code, LeafType leafType, USymbol uSymbol) {
        if (!this.checkConcurrentStateOk(code)) {
            throw new IllegalStateException("Concurrent State " + code);
        }
        if (leafType == null) {
            if (code.getFullName().startsWith("[*]")) {
                throw new IllegalArgumentException();
            }
            if (this.isGroup(code)) {
                return this.getGroup(code);
            }
            return this.getOrCreateLeafDefault(code, LeafType.STATE, null);
        }
        return this.getOrCreateLeafDefault(code, leafType, uSymbol);
    }

    public IEntity getStart() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf(Code.of("*start"), LeafType.CIRCLE_START, null);
        }
        return this.getOrCreateLeaf(Code.of("*start*" + iGroup.getCode().getFullName()), LeafType.CIRCLE_START, null);
    }

    public IEntity getEnd() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf(Code.of("*end"), LeafType.CIRCLE_END, null);
        }
        return this.getOrCreateLeaf(Code.of("*end*" + iGroup.getCode().getFullName()), LeafType.CIRCLE_END, null);
    }

    public IEntity getHistorical() {
        IGroup iGroup = this.getCurrentGroup();
        if (EntityUtils.groupRoot(iGroup)) {
            return this.getOrCreateLeaf(Code.of("*historical"), LeafType.PSEUDO_STATE, null);
        }
        return this.getOrCreateLeaf(Code.of("*historical*" + iGroup.getCode().getFullName()), LeafType.PSEUDO_STATE, null);
    }

    public IEntity getHistorical(Code code) {
        IGroup iGroup = this.getOrCreateGroup(code, Display.getWithNewlines(code), GroupType.STATE, this.getRootGroup());
        IEntity iEntity = this.getOrCreateLeaf(Code.of("*historical*" + iGroup.getCode().getFullName()), LeafType.PSEUDO_STATE, null);
        this.endGroup();
        return iEntity;
    }

    public boolean concurrentState(char c) {
        IGroup iGroup = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(iGroup) && iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        this.getCurrentGroup().setConcurrentSeparator(c);
        IGroup iGroup2 = this.getOrCreateGroup(UniqueSequence.getCode("CONC"), Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        if (!EntityUtils.groupRoot(iGroup) && iGroup.getGroupType() == GroupType.STATE) {
            iGroup.moveEntitiesTo(iGroup2);
            super.endGroup();
            this.getOrCreateGroup(UniqueSequence.getCode("CONC"), Display.create(""), GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        }
        return true;
    }

    @Override
    public void endGroup() {
        IGroup iGroup = this.getCurrentGroup();
        if (!EntityUtils.groupRoot(iGroup) && iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    public final void setHideEmptyDescription(boolean bl) {
        this.hideEmptyDescription = bl;
    }

    @Override
    public final boolean isHideEmptyDescriptionForState() {
        return this.hideEmptyDescription;
    }
}

