/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ClusterDecoration {
    private final UStroke defaultStroke;
    private final PackageStyle style;
    private final USymbol symbol;
    private final TextBlock title;
    private final TextBlock stereo;
    private final HtmlColor stateBack;
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    public static final int marginTitleX1 = 3;
    public static final int marginTitleX2 = 3;
    public static final int marginTitleX3 = 7;
    public static final int marginTitleY0 = 0;
    public static final int marginTitleY1 = 3;
    public static final int marginTitleY2 = 3;

    public ClusterDecoration(PackageStyle packageStyle, USymbol uSymbol, TextBlock textBlock, TextBlock textBlock2, HtmlColor htmlColor, double d, double d2, double d3, double d4, UStroke uStroke) {
        this.symbol = uSymbol;
        this.style = packageStyle;
        this.stereo = textBlock2;
        this.title = textBlock;
        this.stateBack = htmlColor;
        this.minX = d;
        this.minY = d2;
        this.maxX = d3;
        this.maxY = d4;
        this.defaultStroke = uStroke;
    }

    public void drawU(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        if (this.symbol != null) {
            SymbolContext symbolContext = new SymbolContext(this.stateBack, htmlColor).withShadow(bl).withStroke(this.defaultStroke);
            this.symbol.asBig(this.title, this.stereo, this.maxX - this.minX, this.maxY - this.minY, symbolContext).drawU(uGraphic.apply(new UTranslate(this.minX, this.minY)));
            return;
        }
        if (this.style == PackageStyle.NODE) {
            this.drawWithTitleNode(uGraphic, htmlColor, bl);
        } else if (this.style == PackageStyle.CARD) {
            this.drawWithTitleCard(uGraphic, htmlColor, bl);
        } else if (this.style == PackageStyle.DATABASE) {
            this.drawWithTitleDatabase(uGraphic, htmlColor, bl);
        } else if (this.style == PackageStyle.CLOUD) {
            this.drawWithTitleCloud(uGraphic, htmlColor, bl);
        } else if (this.style == PackageStyle.FRAME) {
            this.drawWithTitleFrame(uGraphic, htmlColor, bl);
        } else if (this.style == PackageStyle.RECT) {
            this.drawWithTitleRect(uGraphic, htmlColor, bl);
        } else {
            this.drawWithTitleFolder(uGraphic, htmlColor, bl);
        }
    }

    private void drawWithTitleCloud(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        uGraphic = uGraphic.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(htmlColor));
        uGraphic = uGraphic.apply(this.defaultStroke);
        PackageStyle.CLOUD.drawU(uGraphic.apply(new UTranslate(this.minX, this.minY)), new Dimension2DDouble(d, d2), dimension2D, bl);
        uGraphic = uGraphic.apply(new UStroke());
        this.title.drawU(uGraphic.apply(new UTranslate(this.minX + (d - dimension2D.getWidth()) / 2.0, this.minY + 10.0)));
    }

    private void drawWithTitleDatabase(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        uGraphic = uGraphic.apply(this.defaultStroke);
        uGraphic = uGraphic.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(htmlColor));
        PackageStyle.DATABASE.drawU(uGraphic.apply(new UTranslate(this.minX, this.minY - 10.0)), new Dimension2DDouble(d, d2 + 10.0), dimension2D, bl);
        uGraphic = uGraphic.apply(new UStroke());
        this.title.drawU(uGraphic.apply(new UTranslate(this.minX + 3.0, this.minY + 10.0)));
    }

    private void drawWithTitleFrame(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        uGraphic = uGraphic.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(htmlColor));
        uGraphic = uGraphic.apply(this.defaultStroke);
        PackageStyle.FRAME.drawU(uGraphic.apply(new UTranslate(this.minX, this.minY)), new Dimension2DDouble(d, d2), dimension2D, bl);
        uGraphic = uGraphic.apply(new UStroke());
        this.title.drawU(uGraphic.apply(new UTranslate(this.minX + 3.0, this.minY)));
    }

    private void drawWithTitleCard(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        SymbolContext symbolContext = new SymbolContext(this.stateBack, htmlColor).withStroke(this.defaultStroke).withShadow(bl);
        USymbol.CARD.asBig(this.title, TextBlockUtils.empty(0.0, 0.0), d + 10.0, d2, symbolContext).drawU(uGraphic.apply(new UTranslate(this.minX, this.minY)));
    }

    private void drawWithTitleNode(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        SymbolContext symbolContext = new SymbolContext(this.stateBack, htmlColor).withStroke(this.defaultStroke).withShadow(bl);
        USymbol.NODE.asBig(this.title, TextBlockUtils.empty(0.0, 0.0), d + 10.0, d2, symbolContext).drawU(uGraphic.apply(new UTranslate(this.minX, this.minY)));
    }

    private UPolygon getSpecificFrontierForFolder(StringBounder stringBounder) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        Dimension2D dimension2D = this.title.calculateDimension(stringBounder);
        double d3 = dimension2D.getWidth() + 3.0 + 3.0;
        double d4 = dimension2D.getHeight() + 3.0 + 3.0;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3 + 7.0, d4);
        uPolygon.addPoint(d, d4);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private void drawWithTitleFolder(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D.getWidth() + 3.0 + 3.0;
        double d2 = dimension2D.getHeight() + 3.0 + 3.0;
        UPolygon uPolygon = this.getSpecificFrontierForFolder(uGraphic.getStringBounder());
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(htmlColor));
        uGraphic = uGraphic.apply(this.defaultStroke);
        uGraphic.apply(new UTranslate(this.minX, this.minY)).draw(uPolygon);
        uGraphic.apply(new UTranslate(this.minX, this.minY + d2)).draw(new ULine(d + 7.0, 0.0));
        uGraphic = uGraphic.apply(new UStroke());
        this.title.drawU(uGraphic.apply(new UTranslate(this.minX + 3.0, this.minY + 3.0)));
    }

    private void drawWithTitleRect(UGraphic uGraphic, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        URectangle uRectangle = new URectangle(d, d2);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.stateBack)).apply(new UChangeColor(htmlColor));
        uGraphic = uGraphic.apply(this.defaultStroke);
        uGraphic.apply(new UTranslate(this.minX, this.minY)).draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke());
        double d3 = d - dimension2D.getWidth();
        this.title.drawU(uGraphic.apply(new UTranslate(this.minX + d3 / 2.0, this.minY + 5.0)));
    }
}

