/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class CucaDiagramFileMakerSvek2InternalImage
implements IEntityImage {
    private final List<IEntityImage> inners = new ArrayList<IEntityImage>();
    private final Separator separator;
    private final ISkinParam skinParam;
    private final HtmlColor backColor;

    private HtmlColor getColor(ColorParam colorParam) {
        return new Rose().getHtmlColor(this.skinParam, colorParam);
    }

    public CucaDiagramFileMakerSvek2InternalImage(Collection<ILeaf> collection, char c, ISkinParam iSkinParam, HtmlColor htmlColor) {
        this.separator = Separator.fromChar(c);
        this.skinParam = iSkinParam;
        this.backColor = htmlColor;
        for (ILeaf iLeaf : collection) {
            this.inners.add(iLeaf.getSvekImage());
        }
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        HtmlColor htmlColor = this.getColor(ColorParam.stateBorder);
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        for (int i = 0; i < this.inners.size(); ++i) {
            IEntityImage iEntityImage = this.inners.get(i);
            iEntityImage.drawU(uGraphic);
            Dimension2D dimension2D2 = iEntityImage.calculateDimension(stringBounder);
            uGraphic = uGraphic.apply(this.separator.move(dimension2D2));
            if (i >= this.inners.size() - 1) continue;
            this.separator.drawSeparator(uGraphic.apply(new UChangeColor(htmlColor)), dimension2D);
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = new Dimension2DDouble(0.0, 0.0);
        for (IEntityImage iEntityImage : this.inners) {
            Dimension2D dimension2D2 = iEntityImage.calculateDimension(stringBounder);
            dimension2D = this.separator.add(dimension2D, dimension2D2);
        }
        return dimension2D;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.backColor;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    static enum Separator {
        VERTICAL,
        HORIZONTAL;


        static Separator fromChar(char c) {
            if (c == '|') {
                return VERTICAL;
            }
            if (c == '-') {
                return HORIZONTAL;
            }
            throw new IllegalArgumentException();
        }

        UTranslate move(Dimension2D dimension2D) {
            if (this == VERTICAL) {
                return new UTranslate(dimension2D.getWidth(), 0.0);
            }
            return new UTranslate(0.0, dimension2D.getHeight());
        }

        Dimension2D add(Dimension2D dimension2D, Dimension2D dimension2D2) {
            if (this == VERTICAL) {
                return new Dimension2DDouble(dimension2D.getWidth() + dimension2D2.getWidth(), Math.max(dimension2D.getHeight(), dimension2D2.getHeight()));
            }
            return new Dimension2DDouble(Math.max(dimension2D.getWidth(), dimension2D2.getWidth()), dimension2D.getHeight() + dimension2D2.getHeight());
        }

        void drawSeparator(UGraphic uGraphic, Dimension2D dimension2D) {
            uGraphic = uGraphic.apply(new UStroke(8.0, 10.0, 1.5));
            if (this == VERTICAL) {
                uGraphic.draw(new ULine(0.0, dimension2D.getHeight() + 8.0));
            } else {
                uGraphic.draw(new ULine(dimension2D.getWidth() + 8.0, 0.0));
            }
        }
    }
}

