/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.Untranslated;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageProtected
implements IEntityImage,
Untranslated {
    private final IEntityImage orig;
    private final double border;
    private final Bibliotekon bibliotekon;
    private final Neighborhood neighborhood;

    public EntityImageProtected(IEntityImage iEntityImage, double d, Neighborhood neighborhood, Bibliotekon bibliotekon) {
        this.orig = iEntityImage;
        this.border = d;
        this.bibliotekon = bibliotekon;
        this.neighborhood = neighborhood;
    }

    @Override
    public boolean isHidden() {
        return this.orig.isHidden();
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.orig.getBackcolor();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.orig.calculateDimension(stringBounder), 2.0 * this.border);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.orig.drawU(uGraphic.apply(new UTranslate(this.border, this.border)));
    }

    @Override
    public void drawUntranslated(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.orig.calculateDimension(uGraphic.getStringBounder());
        this.neighborhood.drawU(uGraphic, d + this.border, d2 + this.border, this.bibliotekon, dimension2D);
    }

    @Override
    public ShapeType getShapeType() {
        return this.orig.getShapeType();
    }

    @Override
    public int getShield() {
        return this.orig.getShield();
    }
}

