/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.Version;

public class GraphvizCrash
implements IEntityImage {
    private static final UFont font = new UFont("SansSerif", 0, 12);
    private final GraphicStrings graphicStrings;
    private final BufferedImage flashCode;

    public GraphvizCrash(String string) {
        FlashCodeUtils flashCodeUtils = FlashCodeFactory.getFlashCodeUtils();
        this.flashCode = flashCodeUtils.exportFlashcode(string);
        this.graphicStrings = new GraphicStrings(this.init(), font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
    }

    private List<String> init() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("An error has occured!");
        String string = QuoteUtils.getSomeQuote();
        arrayList.add("<i>" + string);
        arrayList.add(" ");
        arrayList.add("For some reason, dot/Graphviz has crashed.");
        arrayList.add("This has been generated with PlantUML (" + Version.versionString() + ").");
        arrayList.add(" ");
        GraphvizCrash.addProperties(arrayList);
        arrayList.add(" ");
        try {
            String string2 = GraphvizUtils.dotVersion();
            arrayList.add("Default dot version: " + string2);
        }
        catch (Throwable throwable) {
            arrayList.add("Cannot determine dot version: " + throwable.toString());
        }
        arrayList.add(" ");
        arrayList.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        arrayList.add("You can try to turn arround this issue by simplifing your diagram.");
        if (this.flashCode != null) {
            GraphvizCrash.addDecodeHint(arrayList);
        }
        return arrayList;
    }

    public static void addDecodeHint(List<String> list) {
        list.add(" ");
        list.add(" Diagram source: (Use http://zxing.org/w/decode.jspx to decode the flashcode)");
    }

    public static void addProperties(List<String> list) {
        GraphvizCrash.addTextProperty(list, "os.version");
        GraphvizCrash.addTextProperty(list, "os.name");
        GraphvizCrash.addTextProperty(list, "java.vm.vendor");
        GraphvizCrash.addTextProperty(list, "java.vm.version");
        GraphvizCrash.addTextProperty(list, "java.version");
        GraphvizCrash.addTextProperty(list, "user.language");
    }

    private static void addTextProperty(List<String> list, String string) {
        list.add(string + ": " + System.getProperty(string));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public HtmlColor getBackcolor() {
        return HtmlColorUtils.WHITE;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.graphicStrings.calculateDimension(stringBounder);
        if (this.flashCode != null) {
            dimension2D = Dimension2DDouble.mergeTB(dimension2D, new Dimension2DDouble(this.flashCode.getWidth(), this.flashCode.getHeight()));
        }
        return dimension2D;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        this.graphicStrings.drawU(uGraphic);
        if (this.flashCode != null) {
            double d = this.graphicStrings.calculateDimension(uGraphic.getStringBounder()).getHeight();
            uGraphic = uGraphic.apply(new UTranslate(0.0, d));
            uGraphic.draw(new UImage(this.flashCode));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }
}

