/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.Untranslated;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHidden;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public final class SvekResult
implements IEntityImage,
Moveable {
    private final Rose rose = new Rose();
    private ClusterPosition dim;
    private final DotData dotData;
    private final DotStringFactory dotStringFactory;

    public SvekResult(ClusterPosition clusterPosition, DotData dotData, DotStringFactory dotStringFactory) {
        this.dim = clusterPosition;
        this.dotData = dotData;
        this.dotStringFactory = dotStringFactory;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        for (Cluster iterator : this.dotStringFactory.getBibliotekon().allCluster()) {
            iterator.drawU(uGraphic, this.dotData, new UStroke(1.5));
        }
        HtmlColor htmlColor = this.rose.getHtmlColor(this.dotData.getSkinParam(), this.getArrowColorParam(), null);
        for (Shape shape : this.dotStringFactory.getBibliotekon().allShapes()) {
            double d = shape.getMinX();
            double d2 = shape.getMinY();
            UGraphic uGraphic2 = shape.isHidden() ? uGraphic.apply(UHidden.HIDDEN) : uGraphic;
            IEntityImage iEntityImage = shape.getImage();
            iEntityImage.drawU(uGraphic2.apply(new UTranslate(d, d2)));
            if (!(iEntityImage instanceof Untranslated)) continue;
            ((Untranslated)iEntityImage).drawUntranslated(uGraphic.apply(new UChangeColor(htmlColor)), d, d2);
        }
        for (Line line : this.dotStringFactory.getBibliotekon().allLines()) {
            UGraphic uGraphic3 = line.isHidden() ? uGraphic.apply(UHidden.HIDDEN) : uGraphic;
            line.drawU(uGraphic3, htmlColor);
        }
    }

    private ColorParam getArrowColorParam() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.classArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.objectArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.DESCRIPTION) {
            return ColorParam.usecaseArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateArrow;
        }
        throw new IllegalStateException();
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.dotData.getSkinParam().getBackgroundColor();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.dim.getDimension();
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.dotStringFactory.moveSvek(d, d2);
        this.dim = this.dim.delta(d > 0.0 ? d : 0.0, d2 > 0.0 ? d2 : 0.0);
    }

    @Override
    public boolean isHidden() {
        return false;
    }
}

