/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ConnectedCircle
implements UDrawable {
    private final double radius;
    private final List<Double> angles = new ArrayList<Double>();
    private final List<Point2D> points = new ArrayList<Point2D>();

    public ConnectedCircle(double d) {
        this.radius = d;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        UEllipse uEllipse = new UEllipse(2.0 * this.radius, 2.0 * this.radius);
        for (Double object : this.angles) {
            UEllipse uEllipse2 = new UEllipse(2.0 * this.radius, 2.0 * this.radius, object - 30.0, 60.0);
            uGraphic.draw(uEllipse2);
        }
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.GREEN)).apply(new UChangeBackColor(HtmlColorUtils.GREEN));
        for (Point2D point2D : this.points) {
            UTranslate uTranslate = new UTranslate(point2D);
        }
    }

    public void addSecondaryConnection(Point2D point2D) {
        this.points.add(point2D);
        double d = Math.atan2(this.radius - point2D.getY(), point2D.getX() - this.radius);
        d = d * 180.0 / Math.PI;
        System.err.println("pt1=" + point2D + " " + d);
        this.angles.add(d);
    }
}

